/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.rest;

import com.avaya.pim.eventsdk.common.EventSDKConfig;
import com.avaya.pim.eventsdk.exception.IPOMEventErrorCode;
import com.avaya.pim.eventsdk.exception.POMEventException;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import com.avaya.pim.security.util.POMCertificateUtils;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SSLProtocolSocketFactoryClient
extends SSLSocketFactory {
    private static final String TRUST_STORE_PASSWORD = EventSDKConfig.getInstance().getTrustStorePasswordDecrypted();
    private static final String TRUST_STORE_PATH = EventSDKConfig.getInstance().getTrustStorePath();
    private static String[] enabledProtocols = new String[]{"TLSv1.2"};
    private static SSLProtocolSocketFactoryClient instance = null;
    private SSLContext sslcontext = null;
    private SSLSocketFactory underlyingSSLSocketFactory = null;
    private SSLServerSocketFactory underlyingSSLServerSocketFactory = null;

    private SSLProtocolSocketFactoryClient() {
    }

    public static synchronized SSLProtocolSocketFactoryClient getInstance() throws POMEventException {
        if (instance == null) {
            instance = new SSLProtocolSocketFactoryClient();
            instance.initializeSSLContext();
        }
        return instance;
    }

    private void initializeSSLContext() throws POMEventException {
        if (this.sslcontext == null) {
            try (FileInputStream trustStoreInputStream = new FileInputStream(TRUST_STORE_PATH);){
                this.sslcontext = SSLContext.getInstance("TLSv1.2");
                SecureRandom secureRandom = POMSecurityUtils.getSecureRandom();
                secureRandom.nextInt();
                String algorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyStore trustStore = KeyStore.getInstance(POMCertificateUtils.getKeyStoreType());
                trustStore.load(trustStoreInputStream, TRUST_STORE_PASSWORD.toCharArray());
                TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(algorithm);
                tmFactory.init(trustStore);
                this.sslcontext.init(null, tmFactory.getTrustManagers(), secureRandom);
            }
            catch (Exception e) {
                POMEventLoggerHolder.getInstance().error("Unable to create SSL Factory", e);
                throw new POMEventException(IPOMEventErrorCode.UNABLE_TO_CREATE_SSLCONTEXT, "Please check the trust/key store path and password configuration");
            }
        }
        this.underlyingSSLSocketFactory = this.sslcontext.getSocketFactory();
        this.underlyingSSLServerSocketFactory = this.sslcontext.getServerSocketFactory();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.underlyingSSLSocketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        return this.underlyingSSLServerSocketFactory;
    }

    public SSLContext getPomSSLContext() {
        return this.sslcontext;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.underlyingSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.underlyingSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(socket, host, port, autoClose);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    private Socket overrideProtocol(Socket socket) throws SocketException {
        socket.setKeepAlive(true);
        if (socket instanceof SSLSocket && enabledProtocols != null && enabledProtocols.length > 0) {
            ((SSLSocket)socket).setEnabledProtocols(enabledProtocols);
            String[] enabledCiphers = EventSDKConfig.getInstance().getEnabledCipherSuites();
            if (enabledCiphers != null && enabledCiphers.length != 0) {
                ((SSLSocket)socket).setEnabledCipherSuites(enabledCiphers);
            }
        }
        return socket;
    }
}

