/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Arrays;
import org.apache.kafka.common.errors.UnsupportedVersionException;

public class SubscriptionResponseWrapper<FV> {
    static final byte CURRENT_VERSION = 0;
    private final long[] originalValueHash;
    private final FV foreignValue;
    private final byte version;

    public SubscriptionResponseWrapper(long[] originalValueHash, FV foreignValue) {
        this(originalValueHash, foreignValue, 0);
    }

    public SubscriptionResponseWrapper(long[] originalValueHash, FV foreignValue, byte version) {
        if (version != 0) {
            throw new UnsupportedVersionException("SubscriptionWrapper does not support version " + version);
        }
        this.originalValueHash = originalValueHash;
        this.foreignValue = foreignValue;
        this.version = version;
    }

    public long[] getOriginalValueHash() {
        return this.originalValueHash;
    }

    public FV getForeignValue() {
        return this.foreignValue;
    }

    public byte getVersion() {
        return this.version;
    }

    public String toString() {
        return "SubscriptionResponseWrapper{version=" + this.version + ", foreignValue=" + this.foreignValue + ", originalValueHash=" + Arrays.toString(this.originalValueHash) + '}';
    }
}

