/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security.cli;

import com.avaya.pim.security.POMSecurityManager;
import com.avaya.pim.security.exception.POMSecurityCryptoException;
import com.avaya.pim.security.exception.POMSecurityException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.mode.POMSecurityCryptoMode;
import com.avaya.pim.security.util.POMCertificateUtils;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.io.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class POMSecurityManagementTool {
    private static final Logger CONSOLE_LOGGER = POMSecurityLogger.getConsoleLogger();
    private static Console console;
    private static ToolRunMode toolRunMode;
    private static POMSecurityCryptoMode securityCryptoMode;
    private static String data;
    private static RunOperation runOperation;
    private static ToolInternalRequest toolInternalRequest;
    private static int choice;
    private static String[] arguments;
    private static boolean isInternalRequest;
    private static Map<Integer, POMSecurityCryptoMode> cryptoModeNumToEnumMap;
    private static Map<String, POMSecurityCryptoMode> applicablePOMReleaseStrToEnumMap;

    private static void initConsole() {
        console = System.console();
    }

    private static void printUsage() {
        POMSecurityManagementTool.printOnConsole("==================================");
        POMSecurityManagementTool.printOnConsole("POM Security Management Tool Usage");
        POMSecurityManagementTool.printOnConsole("==================================");
        POMSecurityManagementTool.printOnConsole("This tool can be run in both Interactive and Silent Mode.");
        POMSecurityManagementTool.printOnConsole("POM and/or its applications can utilise Silent Mode to cater cryptography requirements.");
        POMSecurityManagementTool.printOnConsole("Silent Mode prints output for a successful operation and prints nothing for a failed operation.");
        POMSecurityManagementTool.printOnConsole("");
        POMSecurityManagementTool.printOnConsole("For Interactive Mode,");
        POMSecurityManagementTool.printOnConsole("   ./POMSecurityManagementTool.sh");
        POMSecurityManagementTool.printOnConsole("");
        POMSecurityManagementTool.printOnConsole("For Silent Mode");
        POMSecurityManagementTool.printOnConsole("   ./POMSecurityManagementTool.sh [ [-h|--help] | [-i|--internal <INTERNAL_REQUEST>] | [-o|--operation <[ENCRYPT|DECRYPT]> -r|--release <[4.X_ONWARDS]> -d|--data <data>] ]");
        POMSecurityManagementTool.printOnConsole("    -h|--help\t\tPrints Tool Usage Information");
        POMSecurityManagementTool.printOnConsole("    -i|--internal\tPOM Internal Request. It will be consumed by POM Scripts for installation/migration. For a list of POM Internal Request Values, contact POM Developement Team.");
        POMSecurityManagementTool.printOnConsole("    -o|--operation\tOperation to be performed. It accepts values as ENCRYPT or DECRYPT");
        POMSecurityManagementTool.printOnConsole("    -r|--release\tPOM Release. It accepts value as 4.X_ONWARDS");
        POMSecurityManagementTool.printOnConsole("    -d|--data\t\tData to be used while performing required encrypt or decrypt operation");
        POMSecurityManagementTool.printOnConsole("");
        POMSecurityManagementTool.printOnConsole("Note: Errors/Messages won't be printed on console when the tool runs in silent mode. Please check log file $POM_HOME/logs/POMSecurityManagementTool.log for more details.");
        POMSecurityManagementTool.printOnConsole("");
        POMSecurityManagementTool.printOnConsole("==================================");
    }

    private static void printOnConsole(String text) {
        System.out.println(text);
    }

    private static void checkLogsAlertForInteractiveMode() {
        POMSecurityManagementTool.printOnConsole("Please check $POM_HOME/logs/POMSecurityManagementTool.log for more details!!");
    }

    private static void getConsoleInputForInteractiveMode() {
        while (true) {
            POMSecurityManagementTool.printOnConsole("");
            POMSecurityManagementTool.printOnConsole("Enter data: ");
            data = runOperation == RunOperation.ENCRYPT ? String.valueOf(console.readPassword()) : console.readLine().replace("\r", "").replace("\n", "").replace("\\", "");
            if (!POMSecurityUtils.isStringNullOrEmpty(data)) break;
            POMSecurityManagementTool.printOnConsole("Data can not be empty. Please enter proper data!");
        }
    }

    private static RunOperation getRunOperation(String operation) {
        return RunOperation.valueOf(operation);
    }

    private static ToolInternalRequest getInternalRequest(String internalRequest) {
        return ToolInternalRequest.valueOf(internalRequest);
    }

    private static void performEncryption() {
        block10: {
            String ENCR_FAIL_ERR_MSG = "Error : Failed to encrypt data!";
            try {
                String encrypted = (String)POMSecurityManager.getInstance().encrypt(data, securityCryptoMode);
                if (!POMSecurityUtils.isStringNullOrEmpty(encrypted)) {
                    if (toolRunMode == ToolRunMode.INTERACTIVE) {
                        POMSecurityManagementTool.printOnConsole("");
                        POMSecurityManagementTool.printOnConsole("Encrypted Data : " + encrypted);
                    } else if (toolRunMode == ToolRunMode.SILENT) {
                        POMSecurityManagementTool.printOnConsole(encrypted);
                    }
                } else if (toolRunMode == ToolRunMode.INTERACTIVE) {
                    POMSecurityManagementTool.notifyFailureForInteractiveMode("Error : Failed to encrypt data!");
                } else if (toolRunMode == ToolRunMode.SILENT) {
                    CONSOLE_LOGGER.log(Level.SEVERE, "Error : Failed to encrypt data!");
                }
            }
            catch (Throwable e) {
                CONSOLE_LOGGER.log(Level.SEVERE, "Error : Failed to encrypt data!", e);
                if (toolRunMode != ToolRunMode.INTERACTIVE) break block10;
                POMSecurityManagementTool.notifyFailureForInteractiveMode("Error : Failed to encrypt data!");
            }
        }
    }

    private static void performDecryption() {
        block10: {
            String DECR_FAIL_ERR_MSG = "Error : Failed to decrypt data!";
            try {
                String decrypted = (String)POMSecurityManager.getInstance().decrypt(data, securityCryptoMode);
                if (!POMSecurityUtils.isStringNullOrEmpty(decrypted)) {
                    if (toolRunMode == ToolRunMode.INTERACTIVE) {
                        POMSecurityManagementTool.printOnConsole("");
                        POMSecurityManagementTool.printOnConsole("Decrypted Data : " + decrypted);
                    } else if (toolRunMode == ToolRunMode.SILENT) {
                        POMSecurityManagementTool.printOnConsole(decrypted);
                    }
                } else if (toolRunMode == ToolRunMode.INTERACTIVE) {
                    POMSecurityManagementTool.notifyFailureForInteractiveMode("Error : Failed to decrypt data!");
                } else if (toolRunMode == ToolRunMode.SILENT) {
                    CONSOLE_LOGGER.log(Level.SEVERE, "Error : Failed to decrypt data!");
                }
            }
            catch (Throwable e) {
                CONSOLE_LOGGER.log(Level.SEVERE, "Error : Failed to decrypt data!", e);
                if (toolRunMode != ToolRunMode.INTERACTIVE) break block10;
                POMSecurityManagementTool.notifyFailureForInteractiveMode("Error : Failed to decrypt data!");
            }
        }
    }

    private static void notifyFailureForInteractiveMode(String ERR_MSG) {
        POMSecurityManagementTool.printOnConsole("");
        POMSecurityManagementTool.printOnConsole(ERR_MSG);
        POMSecurityManagementTool.checkLogsAlertForInteractiveMode();
        CONSOLE_LOGGER.log(Level.SEVERE, ERR_MSG);
    }

    private static void performOperation() {
        if (isInternalRequest) {
            switch (toolInternalRequest) {
                case GET_POM_KEYSTORE_PASSWORD_DECRYPTED: {
                    POMSecurityManagementTool.printOnConsole(POMCertificateUtils.getKeyStorePassword());
                    break;
                }
                case GET_POM_TRUSTSTORE_PASSWORD_DECRYPTED: {
                    POMSecurityManagementTool.printOnConsole(POMCertificateUtils.getTrustStorePassword());
                    break;
                }
                case IS_BCFIPS_INSTALLED: {
                    POMSecurityManagementTool.printOnConsole(String.valueOf(POMSecurityUtils.isBCFIPSInstalled()));
                    break;
                }
                case GET_AAOD_KEYSTORE_PASSWORD_DECRYPTED: {
                    String aaodKeyStorePass = POMSecurityUtils.getAAODKeystorePasswordDecrypted();
                    if (null == aaodKeyStorePass) break;
                    POMSecurityManagementTool.printOnConsole(aaodKeyStorePass);
                }
            }
        } else {
            switch (runOperation) {
                case ENCRYPT: {
                    POMSecurityManagementTool.performEncryption();
                    break;
                }
                case DECRYPT: {
                    POMSecurityManagementTool.performDecryption();
                }
            }
        }
    }

    private static void exitWithMessageAndStatusCode(String msg, int statusCode, Throwable e) {
        CONSOLE_LOGGER.log(Level.SEVERE, msg, e);
        System.exit(statusCode);
    }

    private static void runInteractiveMode() {
        securityCryptoMode = POMSecurityCryptoMode.FIPS_CRYPTO;
        do {
            POMSecurityManagementTool.printOnConsole("");
            POMSecurityManagementTool.printOnConsole("==================================");
            POMSecurityManagementTool.printOnConsole("POM Security Management Tool Menu:");
            POMSecurityManagementTool.printOnConsole("==================================");
            POMSecurityManagementTool.printOnConsole("1. Encrypt");
            POMSecurityManagementTool.printOnConsole("2. Decrypt");
            POMSecurityManagementTool.printOnConsole("3. Tool Usage Information");
            POMSecurityManagementTool.printOnConsole("4. Exit");
            POMSecurityManagementTool.printOnConsole("==================================");
            POMSecurityManagementTool.printOnConsole("");
            POMSecurityManagementTool.printOnConsole("Please enter your preferred choice :");
            Scanner in = new Scanner(System.in);
            try {
                choice = in.nextInt();
            }
            catch (InputMismatchException e) {
                String errMsg = "Invalid Choice...Please enter proper choice!";
                CONSOLE_LOGGER.log(Level.WARNING, errMsg, e);
                POMSecurityManagementTool.printOnConsole(errMsg);
                continue;
            }
            switch (choice) {
                case 1: {
                    runOperation = RunOperation.ENCRYPT;
                    POMSecurityManagementTool.getConsoleInputForInteractiveMode();
                    POMSecurityManagementTool.performOperation();
                    break;
                }
                case 2: {
                    runOperation = RunOperation.DECRYPT;
                    POMSecurityManagementTool.getConsoleInputForInteractiveMode();
                    POMSecurityManagementTool.performOperation();
                    break;
                }
                case 3: {
                    POMSecurityManagementTool.printUsage();
                    break;
                }
                case 4: {
                    POMSecurityManagementTool.printOnConsole("Exiting POM Security Management Tool...");
                    break;
                }
                default: {
                    POMSecurityManagementTool.printOnConsole("Invalid Choice...Please enter proper choice!");
                }
            }
        } while (choice != 4);
    }

    private static void exitIfInvalidOperation(String operation) {
        try {
            runOperation = POMSecurityManagementTool.getRunOperation(operation);
        }
        catch (IllegalArgumentException e) {
            POMSecurityManagementTool.exitWithMessageAndStatusCode("Invalid Operation : " + operation, 1, e);
        }
    }

    private static void exitIfInvalidPOMReleaseStr(String applicableToPOMReleaseStr) {
        securityCryptoMode = applicablePOMReleaseStrToEnumMap.get(applicableToPOMReleaseStr);
        if (null == securityCryptoMode) {
            String errMsg = "Invalid POM Release Value: " + applicableToPOMReleaseStr + " Please check script usage information.";
            POMSecurityManagementTool.exitWithMessageAndStatusCode(errMsg, 1, new POMSecurityCryptoException(errMsg));
        }
    }

    private static void exitIfInvalidInternalRequest(String internalRequest) {
        try {
            toolInternalRequest = POMSecurityManagementTool.getInternalRequest(internalRequest);
        }
        catch (IllegalArgumentException e) {
            POMSecurityManagementTool.exitWithMessageAndStatusCode("Invalid Internal Request : " + internalRequest, 1, e);
        }
    }

    private static void checkAndExitIfInvalidArgsPresent(List<String> invalidArgs) {
        if (!invalidArgs.isEmpty()) {
            String errMsg = "Inavlid Arguments Specified. Exiting POM Security Management Tool...";
            POMSecurityManagementTool.exitWithMessageAndStatusCode(errMsg, 1, new POMSecurityException(errMsg));
        }
    }

    private static void runSilentMode() {
        ArrayList<String> invalidArgs = new ArrayList<String>();
        block16: for (int i = 0; i < arguments.length; i += 2) {
            switch (arguments[i]) {
                case "-i": 
                case "--internal": {
                    POMSecurityManagementTool.exitIfInvalidInternalRequest(arguments[i + 1]);
                    isInternalRequest = true;
                    continue block16;
                }
                case "-o": 
                case "--operation": {
                    POMSecurityManagementTool.exitIfInvalidOperation(arguments[i + 1]);
                    continue block16;
                }
                case "-r": 
                case "--release": {
                    POMSecurityManagementTool.exitIfInvalidPOMReleaseStr(arguments[i + 1]);
                    continue block16;
                }
                case "-d": 
                case "--data": {
                    data = arguments[i + 1];
                    continue block16;
                }
                default: {
                    invalidArgs.add(arguments[i]);
                }
            }
        }
        POMSecurityManagementTool.checkAndExitIfInvalidArgsPresent(invalidArgs);
        POMSecurityManagementTool.performOperation();
    }

    private static void runTool() {
        switch (toolRunMode) {
            case INTERACTIVE: {
                POMSecurityManagementTool.runInteractiveMode();
                break;
            }
            case SILENT: {
                POMSecurityManagementTool.runSilentMode();
            }
        }
    }

    public static void main(String[] args) {
        CONSOLE_LOGGER.log(Level.FINE, "Starting POM Security Management Tool Execution...");
        if (args.length == 0) {
            isInternalRequest = false;
            toolRunMode = ToolRunMode.INTERACTIVE;
            POMSecurityManagementTool.initConsole();
        } else {
            toolRunMode = ToolRunMode.SILENT;
            arguments = (String[])args.clone();
        }
        POMSecurityManagementTool.runTool();
    }

    static {
        isInternalRequest = false;
        cryptoModeNumToEnumMap = new HashMap<Integer, POMSecurityCryptoMode>();
        applicablePOMReleaseStrToEnumMap = new HashMap<String, POMSecurityCryptoMode>();
        for (POMSecurityCryptoMode cryptoMode : POMSecurityCryptoMode.values()) {
            cryptoModeNumToEnumMap.put(cryptoMode.getSecurityCryptoMode(), cryptoMode);
            applicablePOMReleaseStrToEnumMap.put(cryptoMode.getApplicableToPOMReleasesRange(), cryptoMode);
        }
    }

    private static enum ToolInternalRequest {
        GET_POM_KEYSTORE_PASSWORD_DECRYPTED,
        GET_POM_TRUSTSTORE_PASSWORD_DECRYPTED,
        IS_BCFIPS_INSTALLED,
        GET_AAOD_KEYSTORE_PASSWORD_DECRYPTED;

    }

    private static enum ToolRunMode {
        INTERACTIVE,
        SILENT;

    }

    private static enum RunOperation {
        ENCRYPT,
        DECRYPT;

    }
}

