/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security.crypto.impl;

import com.avaya.pim.security.crypto.POMSecurityCryptoModule;
import com.avaya.pim.security.exception.POMSecurityCryptoException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.util.POMSecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.logging.Level;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class POMSecurityFIPSCrypto
implements POMSecurityCryptoModule {
    @Override
    public Object encrypt(Object value) throws POMSecurityCryptoException {
        if (value == null) {
            return null;
        }
        boolean isProviderAlreadyAdded = POMSecurityUtils.isProviderAdded("BCFIPS");
        try {
            ByteArrayOutputStream bos;
            ObjectOutputStream out;
            if (!isProviderAlreadyAdded) {
                POMSecurityUtils.addProvider("BCFIPS");
            }
            if ((out = this.getObjectOutputStream(bos = new ByteArrayOutputStream(), value)) == null) {
                return null;
            }
            byte[] plainText = bos.toByteArray();
            SecureRandom rand = POMSecurityUtils.buildFipsDrbgSecureRandom();
            if (rand == null) {
                return null;
            }
            byte[] initialisationVector = new byte[12];
            rand.nextBytes(initialisationVector);
            SecretKeySpec skey = new SecretKeySpec(POMSecurityUtils.fromHex("395abe20507c1f154ecd404f71e47c3b"), "AES/GCM/NoPadding");
            GCMParameterSpec params = new GCMParameterSpec(128, initialisationVector);
            Cipher cipher = this.getCipher(1, skey, params, value);
            if (cipher == null) {
                return null;
            }
            return this.getFinalEncryptedObject(cipher, initialisationVector, plainText, value);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Messgae : " + e.getMessage(), e);
            throw new POMSecurityCryptoException(e.getMessage(), e);
        }
    }

    private ObjectOutputStream getObjectOutputStream(ByteArrayOutputStream bos, Object value) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(value);
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
        }
        return out;
    }

    private Cipher getCipher(int cipherMode, SecretKeySpec skey, GCMParameterSpec params, Object value) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BCFIPS");
        if (cipher == null) {
            return null;
        }
        try {
            cipher.init(cipherMode, (Key)skey, params);
        }
        catch (InvalidAlgorithmParameterException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
        }
        return cipher;
    }

    private Object getFinalEncryptedObject(Cipher cipher, byte[] initialisationVector, byte[] plainText, Object value) {
        byte[] encrypted = null;
        try {
            encrypted = cipher.doFinal(plainText);
            if (encrypted == null) {
                return null;
            }
            ByteBuffer cipherText = ByteBuffer.allocate(initialisationVector.length + encrypted.length);
            cipherText.put(initialisationVector);
            cipherText.put(encrypted);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(cipherText.array());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to encrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public Object decrypt(Object value) throws POMSecurityCryptoException {
        if (value == null) {
            return null;
        }
        boolean isProviderAlreadyAdded = POMSecurityUtils.isProviderAdded("BCFIPS");
        try {
            GCMParameterSpec params;
            byte[] decodedCipherText;
            if (!isProviderAlreadyAdded) {
                POMSecurityUtils.addProvider("BCFIPS");
            }
            if ((decodedCipherText = this.getDecodedCipherText(value)) == null) {
                return null;
            }
            ByteBuffer cipherText = ByteBuffer.wrap(decodedCipherText);
            byte[] initialisationVector = this.getInitVectorByteArrayFromCipherText(cipherText, value);
            byte[] encrypted = this.getEncryptedByteArrayFromCipherText(cipherText, value);
            if (initialisationVector == null || encrypted == null) {
                return null;
            }
            SecretKeySpec skey = new SecretKeySpec(POMSecurityUtils.fromHex("395abe20507c1f154ecd404f71e47c3b"), "AES/GCM/NoPadding");
            Cipher cipher = this.getCipher(2, skey, params = new GCMParameterSpec(128, initialisationVector), value);
            if (cipher == null) {
                return null;
            }
            return this.getFinalDecryptedObject(cipher, encrypted, value);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Messgae : " + e.getMessage(), e);
            throw new POMSecurityCryptoException(e.getMessage(), e);
        }
    }

    private byte[] getDecodedCipherText(Object value) {
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] decodedCipherText = decoder.decode((String)value);
            return decodedCipherText;
        }
        catch (IllegalArgumentException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    private byte[] getInitVectorByteArrayFromCipherText(ByteBuffer cipherText, Object value) {
        try {
            byte[] initialisationVector = new byte[12];
            cipherText.get(initialisationVector);
            return initialisationVector;
        }
        catch (BufferUnderflowException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    private byte[] getEncryptedByteArrayFromCipherText(ByteBuffer cipherText, Object value) {
        try {
            byte[] encrypted = new byte[cipherText.remaining()];
            cipherText.get(encrypted);
            return encrypted;
        }
        catch (BufferUnderflowException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    private Object getFinalDecryptedObject(Cipher cipher, byte[] encrypted, Object value) {
        byte[] plainText = null;
        try {
            plainText = cipher.doFinal(encrypted);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
        }
        if (plainText == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(plainText);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bis);
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
        }
        if (ois == null) {
            return null;
        }
        try {
            return ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Failed to decrypt data with value = {" + value + "} Error Message : " + e.getMessage(), e);
            return null;
        }
    }

    public static void main(String[] args) {
        POMSecurityFIPSCrypto cryptoModule = new POMSecurityFIPSCrypto();
        try {
            String encrypted = (String)cryptoModule.encrypt("Hello World");
            String decrypted = (String)cryptoModule.decrypt("jEpdwFXQHbLpQfytcHsFUsKvkzEyFBsPWXSrCHKvztjmRaFooGDlFiTgBCfQlw==");
            POMSecurityLogger.getConsoleLogger().log(Level.FINE, "encrypted={0}", encrypted);
            POMSecurityLogger.getConsoleLogger().log(Level.FINE, "decrypted={0}", decrypted);
        }
        catch (POMSecurityCryptoException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error Occurred : " + e);
        }
    }
}

