/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security.logging.formatter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class POMSecurityLoggingConsoleFormatter
extends Formatter {
    private static final String FORMAT = "%1$tb %1$td, %1$tY %1$tl:%1$tM:%1$tS %1$Tp [%2$s] %4$s %5$s%6$s%n";
    private final Date currDate = new Date();

    @Override
    public synchronized String format(LogRecord record) {
        String className;
        this.currDate.setTime(record.getMillis());
        if (record.getSourceClassName() != null) {
            className = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                className = className + " " + record.getSourceMethodName();
            }
        } else {
            className = record.getLoggerName();
        }
        String throwable = "";
        String message = super.formatMessage(record);
        if (record.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println();
            record.getThrown().printStackTrace(printWriter);
            printWriter.close();
            throwable = stringWriter.toString();
        }
        return String.format(FORMAT, this.currDate, className, record.getLoggerName(), record.getLevel(), message, throwable);
    }
}

