/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.function.Predicate;
import org.apache.camel.util.function.TriConsumer;

public class DoubleMap<K1, K2, V> {
    private static final double MAX_LOAD_FACTOR = 1.2;
    private static final int MAX_TABLE_SIZE = 32768;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private Entry[] table;
    private int mask;

    public DoubleMap(int size) {
        this.table = new Entry[DoubleMap.closedTableSize(size)];
        this.mask = this.table.length - 1;
    }

    public V get(K1 k1, K2 k2) {
        Entry[] table = this.table;
        int mask = this.mask;
        int index = DoubleMap.smear(k1.hashCode() * 31 + k2.hashCode()) & mask;
        Entry entry = table[index];
        while (entry != null) {
            if (k1 == entry.k1 && k2 == entry.k2) {
                return (V)entry.v;
            }
            entry = entry.next;
        }
        return null;
    }

    public void forEach(TriConsumer<K1, K2, V> consumer) {
        Entry[] table;
        for (Entry entry : table = this.table) {
            while (entry != null) {
                consumer.accept(entry.k1, entry.k2, entry.v);
                entry = entry.next;
            }
        }
    }

    public boolean containsKey(K1 k1, K2 k2) {
        Entry[] table = this.table;
        int mask = this.mask;
        int index = DoubleMap.smear(k1.hashCode() * 31 + k2.hashCode()) & mask;
        Entry entry = table[index];
        while (entry != null) {
            if (k1 == entry.k1 && k2 == entry.k2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized void put(K1 k1, K2 k2, V v) {
        Entry[] table = this.table;
        int size = this.size() + 1;
        int realSize = DoubleMap.closedTableSize(size);
        if (realSize <= table.length) {
            realSize = table.length;
            int index = DoubleMap.smear(k1.hashCode() * 31 + k2.hashCode()) & realSize - 1;
            Entry oldEntry = table[index];
            while (oldEntry != null) {
                if (oldEntry.k1 == k1 && oldEntry.k2 == k2) {
                    oldEntry.v = v;
                    return;
                }
                oldEntry = oldEntry.next;
            }
            Entry entry = new Entry();
            entry.k1 = k1;
            entry.k2 = k2;
            entry.v = v;
            entry.next = table[index];
            table[index] = entry;
        } else {
            Entry entry;
            Entry[] newT = new Entry[realSize];
            int index = DoubleMap.smear(k1.hashCode() * 31 + k2.hashCode()) & realSize - 1;
            newT[index] = entry = new Entry();
            entry.k1 = k1;
            entry.k2 = k2;
            entry.v = v;
            for (Entry oldEntry : table) {
                while (oldEntry != null) {
                    if (k1 != oldEntry.k1 || k2 != oldEntry.k2) {
                        index = DoubleMap.smear(oldEntry.k1.hashCode() * 31 + oldEntry.k2.hashCode()) & realSize - 1;
                        Entry newEntry = new Entry();
                        newEntry.k1 = oldEntry.k1;
                        newEntry.k2 = oldEntry.k2;
                        newEntry.v = oldEntry.v;
                        newEntry.next = newT[index];
                        newT[index] = newEntry;
                    }
                    oldEntry = oldEntry.next;
                }
            }
            this.table = newT;
            this.mask = realSize - 1;
        }
    }

    public synchronized boolean remove(K1 k1, K2 k2) {
        Entry[] table = this.table;
        int mask = this.mask;
        int index = DoubleMap.smear(k1.hashCode() * 31 + k2.hashCode()) & mask;
        Entry prevEntry = null;
        Entry oldEntry = table[index];
        while (oldEntry != null) {
            if (oldEntry.k1 == k1 && oldEntry.k2 == k2) {
                if (prevEntry == null) {
                    table[index] = oldEntry.next;
                } else {
                    prevEntry.next = oldEntry.next;
                }
                return true;
            }
            prevEntry = oldEntry;
            oldEntry = oldEntry.next;
        }
        return false;
    }

    public V getFirst(Predicate<K1> p1, Predicate<K2> p2) {
        for (Entry entry : this.table) {
            while (entry != null) {
                if (p1.test(entry.k1) && p2.test(entry.k2)) {
                    return (V)entry.v;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    public int size() {
        Entry[] table = this.table;
        int n = 0;
        if (table != null) {
            Entry[] entryArray = table;
            int n2 = entryArray.length;
            for (int i = 0; i < n2; ++i) {
                Entry e;
                Entry c = e = entryArray[i];
                while (c != null) {
                    ++n;
                    c = c.next;
                }
            }
        }
        return n;
    }

    public synchronized void clear() {
        this.table = new Entry[this.table.length];
    }

    static int smear(int hashCode) {
        return 461845907 * Integer.rotateLeft(hashCode * -862048943, 15);
    }

    static int closedTableSize(int expectedEntries) {
        int tableSize;
        if ((expectedEntries = Math.max(expectedEntries, 2)) > (int)(1.2 * (double)(tableSize = Integer.highestOneBit(expectedEntries)))) {
            return (tableSize <<= 1) > 0 ? tableSize : 32768;
        }
        return tableSize;
    }

    static class Entry {
        Object k1;
        Object k2;
        Object v;
        Entry next;

        Entry() {
        }
    }
}

