/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.common;

import com.avaya.pim.eventsdk.exception.IPOMEventErrorCode;
import com.avaya.pim.eventsdk.exception.POMEventException;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import com.avaya.pim.eventsdk.rest.RestUtil;
import com.avaya.pim.security.POMSecurityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.crypto.NoSuchPaddingException;

public class EventSDKConfig {
    private static final String KAFKA_PROPERTY_PREFIX = "kafka";
    private static final String POM_PROPERTY_PREFIX = "pom";
    private static InputStream eventSDKConfigPropertiesInputStream = null;
    private static String EVENT_SDK_CONFIG_FILE_NAME = "eventsdk.properties";
    private static EventSDKConfig eventSDKConfig = new EventSDKConfig();
    private Properties eventSDKConfigProperties = new Properties();
    private Properties kafkaConsumerConfigProperties = new Properties();
    private Properties pomConfigProperties = new Properties();
    private String POM_EVENT_SDK_DIR = "POM_EVENT_SDK_DIR";
    private String kafkaServerString = null;
    private volatile boolean isInitialzed = false;
    private String applicationHome = System.getProperty(this.POM_EVENT_SDK_DIR);

    public static EventSDKConfig getInstance() {
        return eventSDKConfig;
    }

    public void initialize() throws POMEventException {
        try {
            this.applicationHome = System.getProperty(this.POM_EVENT_SDK_DIR);
            POMEventLoggerHolder.getInstance().getLogger().fine("ApplicationHome : " + this.applicationHome);
            if (this.applicationHome == null) {
                POMEventLoggerHolder.getInstance().getLogger().fine("trying to find properties file in current directory as POM_EVENT_SDK_DIR is not set");
                this.applicationHome = System.getProperty("user.dir");
            }
            String eventSDKConfigpropFileName = this.applicationHome + File.separator + EVENT_SDK_CONFIG_FILE_NAME;
            eventSDKConfigpropFileName = eventSDKConfigpropFileName.replace("\\", "/");
            eventSDKConfigpropFileName = eventSDKConfigpropFileName.replace("//", "/");
            eventSDKConfigpropFileName = eventSDKConfigpropFileName.replace("//", "/");
            POMEventLoggerHolder.getInstance().finer("Loading properties file " + eventSDKConfigpropFileName);
            eventSDKConfigPropertiesInputStream = new FileInputStream(eventSDKConfigpropFileName);
            this.eventSDKConfigProperties.load(eventSDKConfigPropertiesInputStream);
            Set<Object> allKeys = this.eventSDKConfigProperties.keySet();
            for (Object propertyKey : allKeys) {
                String propertyName;
                String key = (String)propertyKey;
                if (key.startsWith(KAFKA_PROPERTY_PREFIX)) {
                    propertyName = key.substring(KAFKA_PROPERTY_PREFIX.length() + 1);
                    this.kafkaConsumerConfigProperties.put(propertyName, this.eventSDKConfigProperties.get(key));
                    continue;
                }
                if (key.startsWith(POM_PROPERTY_PREFIX)) {
                    propertyName = key.substring(POM_PROPERTY_PREFIX.length() + 1);
                    this.pomConfigProperties.put(propertyName, this.eventSDKConfigProperties.get(key));
                    continue;
                }
                if ("ssl.truststore.location".equals(key) || "ssl.keystore.location".equals(key)) {
                    this.pomConfigProperties.put(key, this.applicationHome + File.separator + this.eventSDKConfigProperties.get(key));
                    this.kafkaConsumerConfigProperties.put(key, this.applicationHome + File.separator + this.eventSDKConfigProperties.get(key));
                    continue;
                }
                if ("ssl.truststore.password".equals(key) || "ssl.keystore.password".equals(key)) {
                    String pass = (String)this.eventSDKConfigProperties.get(key);
                    boolean isPassEncrypted = Boolean.parseBoolean((String)this.eventSDKConfigProperties.get("pom.eventsdk.use.encrypted.passwords"));
                    String decryptedPass = isPassEncrypted ? this.getDecryptedPassword(pass) : pass;
                    this.pomConfigProperties.put(key, decryptedPass);
                    this.kafkaConsumerConfigProperties.put(key, decryptedPass);
                    continue;
                }
                this.pomConfigProperties.put(key, this.eventSDKConfigProperties.get(key));
                this.kafkaConsumerConfigProperties.put(key, this.eventSDKConfigProperties.get(key));
            }
            this.isInitialzed = true;
        }
        catch (IOException e) {
            POMEventLoggerHolder.getInstance().getLogger().error("initialize", e);
            throw new POMEventException(IPOMEventErrorCode.UNABLE_TO_LOAD_CONFIG_FILE, "Unable to load configuration file");
        }
    }

    private String getDecryptedPassword(String encryptedPass) {
        String decryptedPass = "";
        try {
            decryptedPass = (String)POMSecurityManager.getInstance().decrypt((Object)encryptedPass);
            if (decryptedPass == null) {
                decryptedPass = "";
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMEventLoggerHolder.getInstance().getLogger().error("getDecryptedPassword", e);
            decryptedPass = "";
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("getDecryptedPassword", e);
            decryptedPass = "";
        }
        return decryptedPass;
    }

    public Properties getKafkaConsumerProperties() throws POMEventException {
        if (this.isInitialzed) {
            return this.kafkaConsumerConfigProperties;
        }
        this.initialize();
        return this.kafkaConsumerConfigProperties;
    }

    public Properties getPOMProperties() throws POMEventException {
        if (this.isInitialzed) {
            return this.pomConfigProperties;
        }
        this.initialize();
        return this.pomConfigProperties;
    }

    public String getTrustStorePath() {
        return (String)this.pomConfigProperties.get("ssl.truststore.location");
    }

    public String getTrustStorePasswordDecrypted() {
        return (String)this.pomConfigProperties.get("ssl.truststore.password");
    }

    public String getKeyStorePath() {
        return (String)this.pomConfigProperties.get("ssl.keystore.location");
    }

    public String getKeyStorePasswordDecrypted() {
        return (String)this.pomConfigProperties.get("ssl.keystore.password");
    }

    public String getGroupId() {
        String groupId = (String)this.kafkaConsumerConfigProperties.get("group.id");
        if (groupId != null) {
            return groupId;
        }
        return UUID.randomUUID().toString();
    }

    public String[] getEnabledCipherSuites() {
        String enabledCipherSuites = (String)this.pomConfigProperties.get("enabled.cipher.suites");
        return enabledCipherSuites.split(",");
    }

    public boolean isMessageReceiveAfterStart() {
        String receiveMessageAfterStart = (String)this.pomConfigProperties.get("receive.message.after.start");
        if (receiveMessageAfterStart == null) {
            return true;
        }
        return Boolean.parseBoolean(receiveMessageAfterStart);
    }

    public void populateKafkaServerString(String serverIPAddress) throws POMEventException {
        if (this.getKafkaServerString() == null) {
            String kafkaServerString = RestUtil.getKafkaServerString(serverIPAddress);
            this.setKafkaServerString(kafkaServerString);
        }
    }

    public String getKafkaServerString() {
        return this.kafkaServerString;
    }

    private void setKafkaServerString(String kafkaServerString) {
        this.kafkaServerString = kafkaServerString;
    }

    public boolean isEventPayloadEnabled() {
        String eventPayLoadEnabled = (String)this.pomConfigProperties.get("print.event.payload");
        if (eventPayLoadEnabled == null) {
            return false;
        }
        return Boolean.parseBoolean(eventPayLoadEnabled);
    }

    public void close() {
        try {
            if (eventSDKConfigPropertiesInputStream != null) {
                eventSDKConfigPropertiesInputStream.close();
            }
        }
        catch (IOException e) {
            POMEventLoggerHolder.getInstance().error("Error while closing config properties handle", e);
        }
    }
}

