/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.common;

import com.avaya.pim.eventsdk.common.EventSDKConfig;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.LoginContext;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class Util {
    public static boolean isAuthorizedTenant(String tenantName) {
        if (LoginContext.getInstance() == null) {
            return false;
        }
        String loggedInUsertenantName = LoginContext.getInstance().getOrgName();
        if (tenantName == null || loggedInUsertenantName == null) {
            return false;
        }
        if (loggedInUsertenantName.equals("Default")) {
            return true;
        }
        return tenantName.equals(loggedInUsertenantName);
    }

    public static void printEventMetadata(ConsumerRecord<String, String> record) {
        if (EventSDKConfig.getInstance().isEventPayloadEnabled()) {
            POMEventLoggerHolder.getInstance().getLogger().finest("topic = " + record.topic() + "partition = " + record.partition() + " offset = " + record.offset() + " key = " + (String)record.key() + " value =" + (String)record.value() + " timestamp =" + record.timestamp());
        }
    }

    public static EventTypeEnum getEventTypeEnum(int eventType) {
        return EventTypeEnum.get(eventType);
    }
}

