/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.consumer.AgentEventConsumerThread;
import com.avaya.pim.eventsdk.consumer.AgentStatisticsEventConsumerThread;
import com.avaya.pim.eventsdk.consumer.AttemptResultConsumerThread;
import com.avaya.pim.eventsdk.consumer.CCTrendEventConsumerThread;
import com.avaya.pim.eventsdk.consumer.EnrichedAttemptResultConsumerThread;
import com.avaya.pim.eventsdk.consumer.HeartBeatEventConsumerThread;
import com.avaya.pim.eventsdk.consumer.ImportStatisticsEventConsumerThread;
import com.avaya.pim.eventsdk.consumer.InboundSkillEventConsumerThread;
import com.avaya.pim.eventsdk.consumer.JobEventConsumerThread;
import com.avaya.pim.eventsdk.consumer.JobStatisticsEventConsumerThread;
import com.avaya.pim.eventsdk.core.EventSubscriberHolder;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.exception.POMEventException;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ConsumerThreadManager {
    private EventSubscriberHolder eventSubscriberHolder = null;
    private HeartBeatEventConsumerThread heartBeatEventConsumerThread;
    private JobEventConsumerThread jobEventConsumerThread = null;
    private AgentEventConsumerThread agentEventConsumerThread = null;
    private JobStatisticsEventConsumerThread jobStatisticsEventConsumerThread = null;
    private AgentStatisticsEventConsumerThread agentStatisticsEventConsumerThread = null;
    private AttemptResultConsumerThread attemptResultConsumerThread = null;
    private EnrichedAttemptResultConsumerThread enrichedAttemptResultConsumerThread = null;
    private ImportStatisticsEventConsumerThread importStatisticsConsumerThread = null;
    private InboundSkillEventConsumerThread inboundSkillEventConsumerThread = null;
    private CCTrendEventConsumerThread ccTrendEventConsumerThread = null;

    public ConsumerThreadManager(EventSubscriberHolder eventSubscriberHolder) {
        this.eventSubscriberHolder = eventSubscriberHolder;
    }

    public void startConsumerThread() throws POMEventException {
        this.startHeartBeatEventConsumerThread();
        this.startJobEventConsumerThread();
        this.startAgentEventConsumerThread();
        this.startJobStatisticsEventConsumerThread();
        this.startAgentStatisticsEventConsumerThread();
        this.startAttemptEventConsumerThread();
        this.startEnrichedAttemptEventConsumerThread();
        this.startImportStatsEventConsumerThread();
        this.startInboundSkillEventConsumerThread();
        this.startCCTrendEventConsumerThread();
    }

    private void startHeartBeatEventConsumerThread() throws POMEventException {
        List<POMEvent> pomHeartBeatEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.HEART_BEAT.getValue());
        if (pomHeartBeatEventListener == null || pomHeartBeatEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start HeartBeat event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaHeartBeatEventConsumer = KafkaUtil.getKafkaConsumer("POM.HEARTBEAT");
        this.heartBeatEventConsumerThread = new HeartBeatEventConsumerThread(pomHeartBeatEventListener, kafkaHeartBeatEventConsumer, EventTypeEnum.HEART_BEAT.getValue());
        this.heartBeatEventConsumerThread.setName("HeartBeatEventConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start HeartBeatEventConsumerThread");
        this.heartBeatEventConsumerThread.start();
    }

    private void startJobEventConsumerThread() throws POMEventException {
        List<POMEvent> pomJobEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.JOB.getValue());
        if (pomJobEventListener == null || pomJobEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start job event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaJobEventConsumer = KafkaUtil.getKafkaConsumer("POM_JOB");
        this.jobEventConsumerThread = new JobEventConsumerThread(pomJobEventListener, kafkaJobEventConsumer, EventTypeEnum.JOB.getValue());
        this.jobEventConsumerThread.setName("JobEventConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start JobEventConsumerThread");
        this.jobEventConsumerThread.start();
    }

    private void startAgentEventConsumerThread() throws POMEventException {
        List<POMEvent> pomAgentEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.AGENT.getValue());
        if (pomAgentEventListener == null || pomAgentEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start agent event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaJobEventConsumer = KafkaUtil.getKafkaConsumer("POM_AGENT");
        this.agentEventConsumerThread = new AgentEventConsumerThread(pomAgentEventListener, kafkaJobEventConsumer, EventTypeEnum.AGENT.getValue());
        POMEventLoggerHolder.getInstance().fine("About to start AgentEventConsumerThread");
        this.agentEventConsumerThread.start();
    }

    private void startJobStatisticsEventConsumerThread() throws POMEventException {
        List<POMEvent> pomJobStatisticsEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.JOB_STATISTICS.getValue());
        if (pomJobStatisticsEventListener == null || pomJobStatisticsEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start job statistics event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaJobStatisticsEventConsumer = KafkaUtil.getKafkaConsumer("POM_JOB_STATISTICS");
        this.jobStatisticsEventConsumerThread = new JobStatisticsEventConsumerThread(pomJobStatisticsEventListener, kafkaJobStatisticsEventConsumer, EventTypeEnum.JOB_STATISTICS.getValue());
        this.jobStatisticsEventConsumerThread.setName("JobStatisticsEventConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start JobStatisticsEventConsumerThread");
        this.jobStatisticsEventConsumerThread.start();
    }

    private void startAgentStatisticsEventConsumerThread() throws POMEventException {
        List<POMEvent> pomAgentStatisticsEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.AGENT_STATISTICS.getValue());
        if (pomAgentStatisticsEventListener == null || pomAgentStatisticsEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start agent statistics event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaAgentStatisticsEventConsumer = KafkaUtil.getKafkaConsumer("POM_AGENT_STATISTICS");
        this.agentStatisticsEventConsumerThread = new AgentStatisticsEventConsumerThread(pomAgentStatisticsEventListener, kafkaAgentStatisticsEventConsumer, EventTypeEnum.AGENT_STATISTICS.getValue());
        this.agentStatisticsEventConsumerThread.setName("AgentStatisticsEventConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start AgentStatisticsEventConsumerThread");
        this.agentStatisticsEventConsumerThread.start();
    }

    private void startAttemptEventConsumerThread() throws POMEventException {
        List<POMEvent> attemptEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.ATTEMPT.getValue());
        if (attemptEventListener == null || attemptEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start attempt event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaAttemptResultEventConsumer = KafkaUtil.getKafkaConsumer("POM_ATTEMPT");
        this.attemptResultConsumerThread = new AttemptResultConsumerThread(attemptEventListener, kafkaAttemptResultEventConsumer, EventTypeEnum.ATTEMPT.getValue());
        this.attemptResultConsumerThread.setName("AttemptConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start AttemptResultConsumerThread");
        this.attemptResultConsumerThread.start();
    }

    private void startEnrichedAttemptEventConsumerThread() throws POMEventException {
        List<POMEvent> enrichedAttemptEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.ENRICHED_ATTEMPT_RESULT.getValue());
        if (enrichedAttemptEventListener == null || enrichedAttemptEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start enriched attempt event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaAttemptResultEventConsumer = KafkaUtil.getKafkaConsumer("POM_ENRICHED_ATTEMPT_RESULT");
        this.enrichedAttemptResultConsumerThread = new EnrichedAttemptResultConsumerThread(enrichedAttemptEventListener, kafkaAttemptResultEventConsumer, EventTypeEnum.ENRICHED_ATTEMPT_RESULT.getValue());
        this.enrichedAttemptResultConsumerThread.setName("EnrichedAttemptConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start EnrichedAttemptResultConsumerThread");
        this.enrichedAttemptResultConsumerThread.start();
    }

    private void startImportStatsEventConsumerThread() throws POMEventException {
        List<POMEvent> importStatsEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.IMPORT_STATISTICS.getValue());
        if (importStatsEventListener == null || importStatsEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to import stats event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaAttemptResultEventConsumer = KafkaUtil.getKafkaConsumer("IMPORTSTATISTICS");
        this.importStatisticsConsumerThread = new ImportStatisticsEventConsumerThread(importStatsEventListener, kafkaAttemptResultEventConsumer, EventTypeEnum.IMPORT_STATISTICS.getValue());
        this.importStatisticsConsumerThread.setName("ImportStatisticsConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start ImportStatisticsEventConsumerThread");
        this.importStatisticsConsumerThread.start();
    }

    private void startInboundSkillEventConsumerThread() throws POMEventException {
        List<POMEvent> pomInboundSkillEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.INBOUND_SKILL.getValue());
        if (pomInboundSkillEventListener == null || pomInboundSkillEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start inbound skill event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaInboundSkillEventConsumer = KafkaUtil.getKafkaConsumer("INBOUNDSKILL");
        this.inboundSkillEventConsumerThread = new InboundSkillEventConsumerThread(pomInboundSkillEventListener, kafkaInboundSkillEventConsumer, EventTypeEnum.INBOUND_SKILL.getValue());
        this.inboundSkillEventConsumerThread.setName("InboundSkillConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start InboundSkillEventConsumerThread");
        this.inboundSkillEventConsumerThread.start();
    }

    private void startCCTrendEventConsumerThread() throws POMEventException {
        List<POMEvent> cctrendEventListener = this.eventSubscriberHolder.getEventNotifierList(EventTypeEnum.CCTRENDS.getValue());
        if (cctrendEventListener == null || cctrendEventListener.isEmpty()) {
            POMEventLoggerHolder.getInstance().fine("No need to start cc trend event thread as there is no listener");
            return;
        }
        KafkaConsumer<String, String> kafkaCCTrendEventConsumer = KafkaUtil.getKafkaConsumer("CCTRENDS");
        this.ccTrendEventConsumerThread = new CCTrendEventConsumerThread(cctrendEventListener, kafkaCCTrendEventConsumer, EventTypeEnum.CCTRENDS.getValue());
        this.ccTrendEventConsumerThread.setName("CCTrendEventConsumerThread");
        POMEventLoggerHolder.getInstance().fine("About to start CCTrendEventConsumerThread");
        this.ccTrendEventConsumerThread.start();
    }

    private void stopImportStatsEventThread() {
        if (this.importStatisticsConsumerThread != null && this.importStatisticsConsumerThread.isAlive()) {
            this.importStatisticsConsumerThread.shutdown();
        }
    }

    public void stopEventConsumerThread() {
        POMEventLoggerHolder.getInstance().fine("stopEventConsumerThread");
        this.stopJobEventThread();
        this.stopAgentEventThread();
        this.stopAttemptConsumerThread();
        this.stopImportStatsEventThread();
        this.stopInboundSkillEventThread();
        this.stopHeartBeatEventThread();
        this.stopCCTrendEventConsumerThread();
        POMEventLoggerHolder.getInstance().fine("completed stopEventConsumerThread");
    }

    private void stopHeartBeatEventThread() {
        if (this.heartBeatEventConsumerThread != null && this.heartBeatEventConsumerThread.isAlive()) {
            this.heartBeatEventConsumerThread.shutdown();
        }
    }

    private void stopAgentEventThread() {
        if (this.agentEventConsumerThread != null && this.agentEventConsumerThread.isAlive()) {
            this.agentEventConsumerThread.shutdown();
        }
        if (this.agentStatisticsEventConsumerThread != null && this.agentStatisticsEventConsumerThread.isAlive()) {
            this.agentStatisticsEventConsumerThread.shutdown();
        }
    }

    private void stopJobEventThread() {
        if (this.jobEventConsumerThread != null && this.jobEventConsumerThread.isAlive()) {
            this.jobEventConsumerThread.shutdown();
        }
        if (this.jobStatisticsEventConsumerThread != null && this.jobStatisticsEventConsumerThread.isAlive()) {
            this.jobStatisticsEventConsumerThread.shutdown();
        }
    }

    private void stopAttemptConsumerThread() {
        POMEventLoggerHolder.getInstance().fine("stopResultConsumerThread");
        if (this.attemptResultConsumerThread != null && this.attemptResultConsumerThread.isAlive()) {
            this.attemptResultConsumerThread.shutdown();
        }
        if (this.enrichedAttemptResultConsumerThread != null && this.enrichedAttemptResultConsumerThread.isAlive()) {
            this.enrichedAttemptResultConsumerThread.shutdown();
        }
        POMEventLoggerHolder.getInstance().fine("completed stopResultConsumerThread");
    }

    private void stopInboundSkillEventThread() {
        if (this.inboundSkillEventConsumerThread != null && this.inboundSkillEventConsumerThread.isAlive()) {
            this.inboundSkillEventConsumerThread.shutdown();
        }
    }

    private void stopCCTrendEventConsumerThread() {
        if (this.ccTrendEventConsumerThread != null && this.ccTrendEventConsumerThread.isAlive()) {
            this.ccTrendEventConsumerThread.shutdown();
        }
    }
}

