/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.heartbeat.HeartBeatEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class HeartBeatEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> heartBeatEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public HeartBeatEventConsumerThread(List<POMEvent> heartBeatEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.heartBeatEventNotifierList = heartBeatEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("HeartBeatEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        Util.printEventMetadata((ConsumerRecord<String, String>)record);
                        HeartBeatEvent heartBeatEvent = GsonUtil.getObject((String)record.value(), HeartBeatEvent.class);
                        if (heartBeatEvent == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                            continue;
                        }
                        heartBeatEvent.setRcvdTimeStamp(System.currentTimeMillis());
                        heartBeatEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
                        for (POMEvent pomEventListener : this.heartBeatEventNotifierList) {
                            this.onEventData(pomEventListener, heartBeatEvent);
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in HeartBeatEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private void onEventData(POMEvent pomEventListener, HeartBeatEvent heartBeatEvent) {
        try {
            pomEventListener.onEvent(heartBeatEvent);
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in HeartBeatEventConsumerThread ", e);
        }
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().fine("Error occured while shutting down.");
        }
    }
}

