/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Query;

@InterfaceStability.Evolving
public final class KeyQuery<K, V>
implements Query<V> {
    private final K key;
    private final boolean skipCache;

    private KeyQuery(K key, boolean skipCache) {
        this.key = Objects.requireNonNull(key);
        this.skipCache = skipCache;
    }

    public static <K, V> KeyQuery<K, V> withKey(K key) {
        return new KeyQuery<K, V>(key, false);
    }

    public KeyQuery<K, V> skipCache() {
        return new KeyQuery<K, V>(this.key, true);
    }

    public K getKey() {
        return this.key;
    }

    public boolean isSkipCache() {
        return this.skipCache;
    }
}

