/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.agent.AgentStatisticsEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class AgentStatisticsEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> agentStatisticsEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public AgentStatisticsEventConsumerThread(List<POMEvent> agentStatisticsEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.agentStatisticsEventNotifierList = agentStatisticsEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("AgentStatisticsEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    for (ConsumerRecord record : records) {
                        Util.printEventMetadata((ConsumerRecord<String, String>)record);
                        AgentStatisticsEvent agentStatisticsEvent = GsonUtil.getObject((String)record.value(), AgentStatisticsEvent.class);
                        if (agentStatisticsEvent == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                            continue;
                        }
                        AgentStatisticsEvent transformedAgentStatisticsObject = this.transformAgentStatisticsObject(agentStatisticsEvent);
                        for (POMEvent pomEventListener : this.agentStatisticsEventNotifierList) {
                            try {
                                pomEventListener.onEvent(transformedAgentStatisticsObject);
                            }
                            catch (Exception e) {
                                POMEventLoggerHolder.getInstance().getLogger().error("Error in AgentStatisticsEventConsumerCallback ", e);
                            }
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in AgentEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private AgentStatisticsEvent transformAgentStatisticsObject(AgentStatisticsEvent agentStatisticsEvent) {
        agentStatisticsEvent.setRcvdTimeStamp(System.currentTimeMillis());
        agentStatisticsEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
        return agentStatisticsEvent;
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

