/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.common.KafkaUtil;
import com.avaya.pim.eventsdk.common.Util;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.dto.job.CCTrendEvent;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;

public class CCTrendEventConsumerThread
extends Thread {
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private List<POMEvent> ccTrendEventNotifierList = null;
    private KafkaConsumer<String, String> kafkaConsumer = null;
    private int eventType = -1;

    public CCTrendEventConsumerThread(List<POMEvent> ccTrendEventNotifierList, KafkaConsumer<String, String> kafkaConsumer, int eventType) {
        this.ccTrendEventNotifierList = ccTrendEventNotifierList;
        this.kafkaConsumer = kafkaConsumer;
        this.eventType = eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            POMEventLoggerHolder.getInstance().fine("CCTrendEventConsumerThread started");
            while (this.isRunning.get()) {
                try {
                    ConsumerRecords records = this.kafkaConsumer.poll(Long.MAX_VALUE);
                    POMEventLoggerHolder.getInstance().getLogger().finest("Record size for CCTREND records: " + records.count());
                    for (ConsumerRecord record : records) {
                        Util.printEventMetadata((ConsumerRecord<String, String>)record);
                        CCTrendEvent ccTrendEvent = GsonUtil.getObject((String)record.value(), CCTrendEvent.class);
                        ccTrendEvent.setEventTypeEnum(Util.getEventTypeEnum(this.eventType));
                        if (ccTrendEvent == null) {
                            POMEventLoggerHolder.getInstance().getLogger().error("null object received", null);
                            continue;
                        }
                        for (POMEvent pomEventListener : this.ccTrendEventNotifierList) {
                            this.onCCTrendEvent(pomEventListener, ccTrendEvent);
                        }
                    }
                }
                catch (WakeupException e) {
                    if (!this.isRunning.get()) continue;
                    POMEventLoggerHolder.getInstance().getLogger().error("WakeupException occured ", (Exception)((Object)e));
                }
                catch (Exception e) {
                    POMEventLoggerHolder.getInstance().getLogger().error("Error in CCTrendEventConsumerThread ", e);
                }
            }
        }
        finally {
            KafkaUtil.closeConsumer(this.kafkaConsumer);
        }
    }

    private void onCCTrendEvent(POMEvent pomEventListener, CCTrendEvent ccTrendInfo) {
        try {
            pomEventListener.onEvent(ccTrendInfo);
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().getLogger().error("Error in CCTrendEventConsumerCallback ", e);
        }
    }

    public void shutdown() {
        try {
            this.isRunning.set(false);
            this.kafkaConsumer.wakeup();
        }
        catch (Exception e) {
            POMEventLoggerHolder.getInstance().finest("Error occured while shutting down");
        }
    }
}

