/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.dto.agent;

import java.util.Arrays;

public class ConferenceInfo {
    private String conferenceOwnerId;
    private Participant[] participants;

    public String getConferenceOwnerId() {
        return this.conferenceOwnerId;
    }

    public void setConferenceOwnerId(String conferenceOwnerId) {
        this.conferenceOwnerId = conferenceOwnerId;
    }

    public Participant[] getParticipants() {
        return this.participants;
    }

    public void addParticipants(Participant participant) {
        if (this.participants == null) {
            this.participants = new Participant[1];
            this.participants[0] = participant;
        } else {
            Participant[] tmpParties = new Participant[this.participants.length + 1];
            System.arraycopy(this.participants, 0, tmpParties, 0, this.participants.length);
            tmpParties[this.participants.length] = participant;
            this.participants = tmpParties;
        }
    }

    public ConferenceInfo clone() {
        ConferenceInfo confInfo = new ConferenceInfo();
        confInfo.setConferenceOwnerId(this.getConferenceOwnerId());
        if (this.participants != null && this.participants.length > 0) {
            for (int i = 0; i < this.participants.length; ++i) {
                confInfo.addParticipants(this.participants[i].clone());
            }
        }
        return confInfo;
    }

    public String toString() {
        return "ConferenceInfo [" + (this.conferenceOwnerId != null ? "conferenceOwnerId=" + this.conferenceOwnerId + ", " : "") + (this.participants != null ? "participants=" + Arrays.toString(this.participants) : "") + "]";
    }

    public static class Participant {
        private String partyId;
        private String viaUCID;
        private ParticipantType partyType;

        public String getPartyId() {
            return this.partyId;
        }

        public void setPartyId(String partyId) {
            this.partyId = partyId;
        }

        public String getViaUCID() {
            return this.viaUCID;
        }

        public void setViaUCID(String viaUCID) {
            this.viaUCID = viaUCID;
        }

        public ParticipantType getPartyType() {
            return this.partyType;
        }

        public void setPartyType(ParticipantType partyType) {
            this.partyType = partyType;
        }

        public String toString() {
            return "Participant [" + (this.partyId != null ? "destination=" + this.partyId + ", " : "") + (this.viaUCID != null ? "viaUCID=" + this.viaUCID + ", " : "") + (this.partyType != null ? "partyType=" + (Object)((Object)this.partyType) : "") + "]";
        }

        public Participant clone() {
            Participant party = new Participant();
            party.setPartyId(this.getPartyId());
            party.setPartyType(this.getPartyType());
            party.setViaUCID(this.getViaUCID());
            return party;
        }

        public static enum ParticipantType {
            AGENT,
            CUSTOMER,
            EXTERNAL_PARTY;

        }
    }
}

