/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.core;

import com.avaya.pim.eventsdk.common.EventSDKConfig;
import com.avaya.pim.eventsdk.consumer.ConsumerThreadManager;
import com.avaya.pim.eventsdk.core.EventSubscriberHolder;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.LoginContext;
import com.avaya.pim.eventsdk.core.POMAgentEventNotifier;
import com.avaya.pim.eventsdk.core.POMAgentStatisticsEventNotifier;
import com.avaya.pim.eventsdk.core.POMAttemptEventNotifier;
import com.avaya.pim.eventsdk.core.POMCCTrendEventNotifier;
import com.avaya.pim.eventsdk.core.POMEnrichedAttemptEventNotifier;
import com.avaya.pim.eventsdk.core.POMEvent;
import com.avaya.pim.eventsdk.core.POMHeartBeatEventNotifier;
import com.avaya.pim.eventsdk.core.POMImportStatisticsEventNotifier;
import com.avaya.pim.eventsdk.core.POMInboundSkillEventNotifier;
import com.avaya.pim.eventsdk.core.POMJobEventNotifier;
import com.avaya.pim.eventsdk.core.POMJobStatisticsEventNotifier;
import com.avaya.pim.eventsdk.dto.LoginOption;
import com.avaya.pim.eventsdk.exception.IPOMEventErrorCode;
import com.avaya.pim.eventsdk.exception.POMEventException;
import com.avaya.pim.eventsdk.logger.ILogger;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import com.avaya.pim.eventsdk.rest.RestUtil;
import com.avaya.pim.eventsdk.rest.SSLProtocolSocketFactoryClient;
import javax.net.ssl.SSLContext;

public class POMEventRegistrar {
    private static final POMEventRegistrar instance = new POMEventRegistrar();
    private volatile boolean isInitialied = false;
    private EventSubscriberHolder eventSubscriberHolder = null;
    private ConsumerThreadManager consumerThreadManager = null;
    private String POMIPAddress = null;
    private LoginOption loginOption = null;

    public static POMEventRegistrar getInstance() {
        return instance;
    }

    private static boolean isValidImplementation(boolean isJobEvent, boolean isAgentEvent, boolean isAttemptEvent, boolean isHeartBeatEvent, boolean isImportStatsEvent, boolean isInboundSkillEvent, boolean isCCTrendEventEvent) {
        return isJobEvent || isAgentEvent || isAttemptEvent || isHeartBeatEvent || isImportStatsEvent || isInboundSkillEvent || isCCTrendEventEvent;
    }

    public synchronized void login(String userName, String password, String POMIPAddress, ILogger logger, LoginOption loginOption) throws POMEventException {
        if (logger == null) {
            throw new POMEventException(IPOMEventErrorCode.INVALID_LOGGER, "Logger implementation is null");
        }
        if (LoginContext.isUserLoggedIn()) {
            throw new POMEventException(IPOMEventErrorCode.USER_ALREADY_LOGGED_IN, "User " + LoginContext.getInstance().getUserName() + " is already logged in");
        }
        POMEventLoggerHolder.getInstance().setLogger(logger);
        EventSDKConfig.getInstance().initialize();
        POMEventLoggerHolder.getInstance().fine("EventSDK Configuration has been initialized");
        POMEventLoggerHolder.getInstance().fine("LoginOption " + loginOption);
        this.setLoginOption(loginOption);
        RestUtil.authorizeUser(POMIPAddress, userName, password);
        this.POMIPAddress = POMIPAddress;
        this.eventSubscriberHolder = new EventSubscriberHolder();
        this.consumerThreadManager = new ConsumerThreadManager(this.eventSubscriberHolder);
    }

    public synchronized void initialize() throws POMEventException {
        if (!LoginContext.isUserLoggedIn()) {
            throw new POMEventException(IPOMEventErrorCode.USER_NOT_LOGGED_IN, "User is not logged in");
        }
        EventSDKConfig.getInstance().populateKafkaServerString(this.POMIPAddress);
        this.consumerThreadManager.startConsumerThread();
        this.isInitialied = true;
    }

    public synchronized String subscribe(EventTypeEnum eventTypeEnum, POMEvent eventImpl) throws POMEventException {
        if (this.isInitialied) {
            throw new POMEventException(IPOMEventErrorCode.ALREADY_INITIALIZED, "Can not subscribe after initialization");
        }
        POMEventLoggerHolder.getInstance().finest("subscribe request for " + eventTypeEnum.name());
        if (!LoginContext.isUserLoggedIn()) {
            throw new POMEventException(IPOMEventErrorCode.USER_NOT_LOGGED_IN, "User is not logged in");
        }
        if (this.isValidImplementation(eventTypeEnum, eventImpl)) {
            return this.eventSubscriberHolder.addNotifier(eventTypeEnum, eventImpl);
        }
        throw new POMEventException(IPOMEventErrorCode.INVALID_IMPLEMENTATION, "Invalid implementation for event type");
    }

    private boolean isValidImplementation(EventTypeEnum eventTypeEnum, POMEvent eventImpl) throws POMEventException {
        boolean isJobEvent = eventTypeEnum.equals((Object)EventTypeEnum.JOB) && eventImpl instanceof POMJobEventNotifier || eventTypeEnum.equals((Object)EventTypeEnum.JOB_STATISTICS) && eventImpl instanceof POMJobStatisticsEventNotifier;
        boolean isAgentEvent = eventTypeEnum.equals((Object)EventTypeEnum.AGENT) && eventImpl instanceof POMAgentEventNotifier || eventTypeEnum.equals((Object)EventTypeEnum.AGENT_STATISTICS) && eventImpl instanceof POMAgentStatisticsEventNotifier;
        boolean isAttemptEvent = eventTypeEnum.equals((Object)EventTypeEnum.ATTEMPT) && eventImpl instanceof POMAttemptEventNotifier || eventTypeEnum.equals((Object)EventTypeEnum.ENRICHED_ATTEMPT_RESULT) && eventImpl instanceof POMEnrichedAttemptEventNotifier;
        boolean isHeartBeatEvent = eventTypeEnum.equals((Object)EventTypeEnum.HEART_BEAT) && eventImpl instanceof POMHeartBeatEventNotifier;
        boolean isImportStatsEvent = eventTypeEnum.equals((Object)EventTypeEnum.IMPORT_STATISTICS) && eventImpl instanceof POMImportStatisticsEventNotifier;
        boolean isInboundSkillEvent = eventTypeEnum.equals((Object)EventTypeEnum.INBOUND_SKILL) && eventImpl instanceof POMInboundSkillEventNotifier;
        boolean isCCTrendEventEvent = eventTypeEnum.equals((Object)EventTypeEnum.CCTRENDS) && eventImpl instanceof POMCCTrendEventNotifier;
        return POMEventRegistrar.isValidImplementation(isJobEvent, isAgentEvent, isAttemptEvent, isHeartBeatEvent, isImportStatsEvent, isInboundSkillEvent, isCCTrendEventEvent);
    }

    public synchronized boolean unsubscribe(String uniqueId) throws POMEventException {
        return this.eventSubscriberHolder.removeNotifier(uniqueId);
    }

    public synchronized void logoff() {
        if (this.consumerThreadManager != null) {
            this.consumerThreadManager.stopEventConsumerThread();
        }
        this.isInitialied = false;
        this.loginOption = null;
        if (LoginContext.getInstance() != null) {
            LoginContext.getInstance().destory();
        }
        EventSDKConfig.getInstance().close();
    }

    public LoginOption getLoginOption() {
        return this.loginOption;
    }

    private void setLoginOption(LoginOption loginOption) throws POMEventException {
        if (loginOption == null) {
            SSLContext sslContext = SSLProtocolSocketFactoryClient.getInstance().getPomSSLContext();
            this.loginOption = new LoginOption(sslContext, 443);
            POMEventLoggerHolder.getInstance().fine("Default LoginOption : " + this.loginOption);
            return;
        }
        this.loginOption = new LoginOption();
        if (loginOption.getPomPortNumber() != 0) {
            this.loginOption.setPomPortNumber(loginOption.getPomPortNumber());
        } else {
            this.loginOption.setPomPortNumber(443);
        }
        if (loginOption.getSslContext() != null) {
            this.loginOption.setSslContext(loginOption.getSslContext());
        } else {
            SSLContext sslContext = SSLProtocolSocketFactoryClient.getInstance().getPomSSLContext();
            this.loginOption.setSslContext(sslContext);
        }
        POMEventLoggerHolder.getInstance().fine("LoginOption has been set : " + loginOption);
    }
}

