/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.dto.agent;

import java.util.Arrays;

public class ConsultInfo
implements Cloneable {
    private ConsultType consultType;
    private String consultOwnerId;
    private String consultedParty;
    private Participant[] participants;
    private String consultCallUCID;

    public ConsultType getConsultType() {
        return this.consultType;
    }

    public void setConsultType(ConsultType consultType) {
        this.consultType = consultType;
    }

    public String getConsultOwnerId() {
        return this.consultOwnerId;
    }

    public void setConsultOwnerId(String consultOwnerId) {
        this.consultOwnerId = consultOwnerId;
    }

    public Participant[] getParticipants() {
        return this.participants;
    }

    public void addParticipants(Participant participant) {
        if (this.participants == null) {
            this.participants = new Participant[1];
            this.participants[0] = participant;
        } else {
            Participant[] tmpParties = new Participant[this.participants.length + 1];
            System.arraycopy(this.participants, 0, tmpParties, 0, this.participants.length);
            tmpParties[this.participants.length] = participant;
            this.participants = tmpParties;
        }
    }

    public String getConsultedParty() {
        return this.consultedParty;
    }

    public void setConsultedParty(String consultedParty) {
        this.consultedParty = consultedParty;
    }

    public String getConsultCallUCID() {
        return this.consultCallUCID;
    }

    public void setConsultCallUCID(String consultCallUCID) {
        this.consultCallUCID = consultCallUCID;
    }

    public ConsultInfo clone() {
        ConsultInfo consultInfo = new ConsultInfo();
        consultInfo.setConsultOwnerId(this.getConsultOwnerId());
        consultInfo.setConsultType(this.getConsultType());
        consultInfo.setConsultedParty(this.getConsultedParty());
        consultInfo.setConsultCallUCID(this.getConsultCallUCID());
        if (this.participants != null && this.participants.length > 0) {
            for (int i = 0; i < this.participants.length; ++i) {
                consultInfo.addParticipants(this.participants[i].clone());
            }
        }
        return consultInfo;
    }

    public String toString() {
        return "ConsultInfo [" + (this.consultType != null ? "consultType=" + (Object)((Object)this.consultType) + ", " : "") + (this.consultOwnerId != null ? "consultOwnerId=" + this.consultOwnerId + ", " : "") + (this.consultedParty != null ? "consultedParty=" + this.consultedParty + ", " : "") + (this.participants != null ? "participants=" + Arrays.toString(this.participants) + ", " : "") + (this.consultCallUCID != null ? "consultCallUCID=" + this.consultCallUCID : "") + "]";
    }

    public static class Participant {
        private String partyId;
        private String viaUCID;
        private ParticipantType partyType;

        public String getPartyId() {
            return this.partyId;
        }

        public void setPartyId(String partyId) {
            this.partyId = partyId;
        }

        public String getViaUCID() {
            return this.viaUCID;
        }

        public void setViaUCID(String viaUCID) {
            this.viaUCID = viaUCID;
        }

        public ParticipantType getPartyType() {
            return this.partyType;
        }

        public void setPartyType(ParticipantType partyType) {
            this.partyType = partyType;
        }

        public String toString() {
            return "Participant [" + (this.partyId != null ? "destination=" + this.partyId + ", " : "") + (this.viaUCID != null ? "viaUCID=" + this.viaUCID + ", " : "") + (this.partyType != null ? "partyType=" + (Object)((Object)this.partyType) : "") + "]";
        }

        public Participant clone() {
            Participant party = new Participant();
            party.setPartyId(this.getPartyId());
            party.setPartyType(this.getPartyType());
            party.setViaUCID(this.getViaUCID());
            return party;
        }

        public static enum ParticipantType {
            AGENT,
            CUSTOMER,
            EXTERNAL_PARTY;

        }
    }

    public static enum ConsultType {
        AGENT,
        EXTERNAL;

    }
}

