/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.security.util;

import com.avaya.pim.appserver.security.crypto.impl.AAODSecurityCrypto;
import com.avaya.pim.security.POMSecurityManager;
import com.avaya.pim.security.crypto.POMSecurityCryptoModule;
import com.avaya.pim.security.crypto.impl.POMSecurityDefaultCrypto;
import com.avaya.pim.security.crypto.impl.POMSecurityFIPSCrypto;
import com.avaya.pim.security.exception.POMSecurityException;
import com.avaya.pim.security.logging.POMSecurityLogger;
import com.avaya.pim.security.mode.POMSecurityCryptoMode;
import com.avaya.pim.security.util.POMCertificateUtils;
import com.avaya.pim.security.util.POMSecurityConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import java.util.Properties;
import java.util.logging.Level;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.util.OrderedProperties;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.util.BasicEntropySourceProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class POMSecurityUtils {
    private static POMSecurityManager securityManager = POMSecurityManager.getInstance();
    private static boolean isBCFIPSModeInstalled = POMSecurityUtils.checkValidBCFIPSProviderInstalled();

    private POMSecurityUtils() {
        throw new IllegalStateException("Utility classes, which are collections of static members, are not meant to be instantiated. Even abstract utility classes, which can be extended should not have public constructors. Java adds an implicit public constructor to every class which does not define at least one explicitly. Hence, at least one non-public constructor should be defined.");
    }

    public static boolean getFIPSMode() {
        boolean getfipsMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        POMSecurityLogger.getConsoleLogger().log(Level.ALL, "getFIPSMode: Process is in FIPS Mode = " + getfipsMode);
        return getfipsMode;
    }

    public static void detectAndsetFIPSMode() {
        if (isBCFIPSModeInstalled && !CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            POMSecurityLogger.getConsoleLogger().log(Level.ALL, "detectAndsetFIPSMode: Setting the FIPSonly Mode");
            CryptoServicesRegistrar.setApprovedOnlyMode((boolean)true);
        }
        POMSecurityUtils.getFIPSMode();
    }

    public static void setupSSLProps() {
        System.setProperty("javax.net.ssl.keyStore", POMCertificateUtils.getKeyStorePath());
        System.setProperty("javax.net.ssl.keyStorePassword", POMCertificateUtils.getKeyStorePassword());
        System.setProperty("javax.net.ssl.keyStoreType", POMCertificateUtils.getKeyStoreType());
        System.setProperty("javax.net.ssl.trustStore", POMCertificateUtils.getTrustStorePath());
        System.setProperty("javax.net.ssl.trustStorePassword", POMCertificateUtils.getTrustStorePassword());
        System.setProperty("javax.net.ssl.trustStoreType", POMCertificateUtils.getKeyStoreType());
    }

    public static boolean isBCFIPSInstalled() {
        return isBCFIPSModeInstalled;
    }

    public static POMSecurityCryptoModule getPOMSecurityCryptoModule() {
        return new POMSecurityFIPSCrypto();
    }

    public static POMSecurityCryptoModule getPOMSecurityCryptoModule(POMSecurityCryptoMode pomSecurityCryptoMode) {
        switch (pomSecurityCryptoMode) {
            case DEFAULT_CRYPTO: {
                return new POMSecurityDefaultCrypto();
            }
            case FIPS_CRYPTO: {
                return new POMSecurityFIPSCrypto();
            }
        }
        return null;
    }

    public static byte[] fromHex(String hexStr) {
        if (!hexStr.matches("^[0-9a-fA-F]*$")) {
            return new byte[0];
        }
        byte[] retval = new byte[hexStr.length() >> 1];
        int i = 0;
        while (hexStr.length() > 1) {
            retval[i++] = (byte)Integer.parseInt(hexStr.substring(0, 2), 16);
            hexStr = hexStr.substring(2);
        }
        return retval;
    }

    public static String toHex(byte[] bytes) {
        String HEX_DIGITS = "0123456789abcdef";
        if (bytes.length == 0) {
            return null;
        }
        StringBuilder retval = new StringBuilder("");
        for (int i = 0; i < bytes.length; ++i) {
            retval.append("0123456789abcdef".charAt(bytes[i] >> 4 & 0xF));
            retval.append("0123456789abcdef".charAt(bytes[i] & 0xF));
        }
        return retval.toString();
    }

    public static void printProvider() {
        for (Provider p : Security.getProviders()) {
            POMSecurityLogger.getConsoleLogger().log(Level.FINE, "Providers= {0}", p.getName());
        }
    }

    public static SecureRandom getSecureRandom() {
        if (POMSecurityUtils.isBCFIPSInstalled()) {
            try {
                return SecureRandom.getInstance("DEFAULT", "BCFIPS");
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to get Secure Random instance. " + e.getMessage(), e);
                throw new POMSecurityException(e.getMessage(), e);
            }
        }
        return new SecureRandom();
    }

    private static boolean checkValidBCFIPSProviderInstalled() {
        for (Provider pr : Security.getProviders()) {
            if (!pr.getInfo().contains("Sun JSSE provider (FIPS mode, crypto provider BCFIPS")) continue;
            return true;
        }
        return false;
    }

    public static String getApplicationHome() {
        String variable = System.getenv("POM_HOME");
        variable = variable.replace("%20", " ");
        variable = variable.replace("\\", "/");
        variable = variable.replace("//", "/");
        variable = variable.replace("//", "/");
        return variable;
    }

    public static String getSSLInstance(String protocol) {
        if (POMSecurityUtils.isBCFIPSInstalled()) {
            return "TLSv1.2";
        }
        return protocol;
    }

    public static SecureRandom buildFipsDrbgSecureRandom() {
        BasicEntropySourceProvider entSource = null;
        entSource = new BasicEntropySourceProvider(new SecureRandom(), true);
        byte[] nonce = Strings.toByteArray((String)"The value specified here gets converted into an array of bytes for the purpose of NONCE");
        FipsDRBG.Builder drgbBldr = FipsDRBG.SHA512_HMAC.fromEntropySource((EntropySourceProvider)entSource).setSecurityStrength(256).setEntropyBitsRequired(256);
        return drgbBldr.build(nonce, false);
    }

    public static SecureRandom buildFipsDrbgSecureRandomForKeys() {
        BasicEntropySourceProvider entSource;
        try {
            entSource = new BasicEntropySourceProvider(SecureRandom.getInstanceStrong(), true);
        }
        catch (NoSuchAlgorithmException e) {
            throw new POMSecurityException(e.getMessage(), e);
        }
        byte[] personalizationString = Strings.toByteArray((String)"Avaya Proactive Outreach Manger FIPS 140-2 Security Module");
        FipsDRBG.Builder drgbBldr = FipsDRBG.SHA512_HMAC.fromEntropySource((EntropySourceProvider)entSource).setSecurityStrength(256).setEntropyBitsRequired(256).setPersonalizationString(personalizationString);
        return drgbBldr.build(Strings.toByteArray((String)"The value specified here gets converted into an array of bytes for the purpose of NONCE"), true);
    }

    public static void setDefaultSecureRandomForFipsMode() {
        BasicEntropySourceProvider entSource;
        try {
            entSource = new BasicEntropySourceProvider(SecureRandom.getInstanceStrong(), true);
        }
        catch (NoSuchAlgorithmException e) {
            throw new POMSecurityException(e.getMessage(), e);
        }
        byte[] nonce = Strings.toByteArray((String)"The value specified here gets converted into an array of bytes for the purpose of NONCE");
        FipsDRBG.Builder drgbBldr = FipsDRBG.SHA512.fromEntropySource((EntropySourceProvider)entSource).setSecurityStrength(256).setEntropyBitsRequired(256);
        CryptoServicesRegistrar.setSecureRandom((SecureRandom)drgbBldr.build(nonce, true));
    }

    public static SecretKey generateSecretKeyForFipsMode() throws GeneralSecurityException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "BCFIPS");
        keyGenerator.init(256, POMSecurityUtils.buildFipsDrbgSecureRandomForKeys());
        return keyGenerator.generateKey();
    }

    public static String generateSecretKeyForFipsModeString() throws GeneralSecurityException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "BCFIPS");
        keyGenerator.init(256, POMSecurityUtils.buildFipsDrbgSecureRandomForKeys());
        return Base64.getEncoder().encodeToString(keyGenerator.generateKey().getEncoded());
    }

    public static Provider getProvider(String providerName) {
        BouncyCastleFipsProvider provider = null;
        switch (providerName) {
            case "BCFIPS": {
                provider = new BouncyCastleFipsProvider();
                break;
            }
            default: {
                POMSecurityLogger.getConsoleLogger().log(Level.FINE, "Provider " + providerName + "not available.");
            }
        }
        return provider;
    }

    public static boolean isProviderAdded(String providerName) {
        boolean isProviderAdded = true;
        if (Security.getProvider(providerName) == null) {
            isProviderAdded = false;
        }
        return isProviderAdded;
    }

    public static void addProvider(String providerName) {
        try {
            Security.addProvider(POMSecurityUtils.getProvider(providerName));
        }
        catch (Exception e) {
            POMSecurityLogger.getConsoleLogger().log(Level.FINE, "Failed to add provider {providerName=" + providerName + "} : " + e.getMessage(), e);
            throw e;
        }
    }

    public static void removeProvider(String providerName) {
        Security.removeProvider(providerName);
    }

    public static void insertProviderAt(String providerName, int position) {
        if (position <= 0) {
            throw new IllegalArgumentException("Invalid Position!");
        }
        Security.insertProviderAt(POMSecurityUtils.getProvider(providerName), position);
    }

    public static String getDefaultPOMKeystorePassword() {
        try {
            return (String)POMSecurityManager.getInstance().decrypt("VUep9Vo3NQjFUSL/wNgCRIFh6yb2tLQxzJ7Kat0rzM9ZuKiL6VFak4LIfg==");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to get Default POM Keystore Password", e);
            return "";
        }
    }

    public static String getDefaultPOMTruststorePassword() {
        try {
            return (String)POMSecurityManager.getInstance().decrypt("VUep9Vo3NQjFUSL/wNgCRIFh6yb2tLQxzJ7Kat0rzM9ZuKiL6VFak4LIfg==");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to get Default POM Truststore Password", e);
            return "";
        }
    }

    public static Object getPropertyValueFromPropertiesFile(String file, String propertyKey) {
        Object propertyValue = null;
        Properties configProps = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            configProps.load(in);
            propertyValue = configProps.get(propertyKey);
        }
        catch (FileNotFoundException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Unable to find the specified properties file " + file, e);
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error Occurred : " + e.getMessage(), e);
        }
        return propertyValue;
    }

    public static boolean updatePropertyValueInPropertiesFile(String file, String propertyKey, String newPropertyValue) {
        Throwable throwable;
        boolean errorOccurred = false;
        boolean isPropertyUpdated = false;
        boolean isPropertyFound = false;
        OrderedProperties configProps = new OrderedProperties();
        try {
            throwable = null;
            try (FileInputStream in = new FileInputStream(file);){
                configProps.load(in);
                if (configProps.get(propertyKey) != null) {
                    isPropertyFound = true;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Unable to find the specified properties file " + file, e);
            errorOccurred = true;
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error Occurred : " + e.getMessage(), e);
            errorOccurred = true;
        }
        if (!errorOccurred && isPropertyFound) {
            configProps.setProperty(propertyKey, newPropertyValue);
            try {
                throwable = null;
                try (FileOutputStream out = new FileOutputStream(file);){
                    configProps.store(out, null);
                    isPropertyUpdated = true;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to update properties file " + file, e);
                errorOccurred = true;
            }
        }
        return isPropertyUpdated && !errorOccurred;
    }

    public static boolean addOrUpdatePropertyValueInPropertiesFile(String file, String propertyKey, String propertyValue) {
        Throwable throwable;
        boolean isPropertyAddedOrUpdated = false;
        boolean isPropertyFound = false;
        boolean errorOccurred = false;
        OrderedProperties configProps = new OrderedProperties();
        try {
            throwable = null;
            try (FileInputStream in = new FileInputStream(file);){
                configProps.load(in);
                if (configProps.get(propertyKey) != null) {
                    isPropertyFound = true;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Unable to find the specified properties file " + file, e);
            errorOccurred = true;
        }
        catch (IOException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error Occurred : " + e.getMessage(), e);
            errorOccurred = true;
        }
        if (!errorOccurred) {
            if (isPropertyFound) {
                configProps.setProperty(propertyKey, propertyValue);
            } else {
                configProps.put(propertyKey, propertyValue);
            }
            try {
                throwable = null;
                try (FileOutputStream out = new FileOutputStream(file);){
                    configProps.store(out, null);
                    isPropertyAddedOrUpdated = true;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to update properties file " + file, e);
                errorOccurred = true;
            }
        }
        return isPropertyAddedOrUpdated && !errorOccurred;
    }

    public static String fallbackMechanismForFailedDecryption(String defaultEncryptedValue) {
        String defaultDecryptedValue = "";
        try {
            defaultDecryptedValue = (String)securityManager.decrypt(defaultEncryptedValue);
            if (defaultDecryptedValue == null) {
                defaultDecryptedValue = "";
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed while handling decryption fallback mechanism.", e);
        }
        return defaultDecryptedValue;
    }

    public static String getAAODAppserverHome() {
        String variable = System.getenv("APPSERVER_HOME");
        variable = variable.replace("%20", " ");
        variable = variable.replace("\\", "/");
        variable = variable.replace("//", "/");
        variable = variable.replace("//", "/");
        return variable;
    }

    public static String getAAODDAppserverConfigFilePath() {
        return POMSecurityUtils.getAAODAppserverHome() + POMSecurityConstants.AAOD_APPSERVER_DDCONFIG_XML_REL_PATH;
    }

    public static Document getW3CDomDocument(File file) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            String errMsg = "Failed to get W3C DOM Document from file [" + file + "]";
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, errMsg, e);
            throw new POMSecurityException(errMsg, e);
        }
    }

    public static String getAAODKeystorePasswordDecrypted() {
        String aaodKeystorePassDecrypted = null;
        try {
            String AAOD_DDCONFIG_FILE_STR = POMSecurityUtils.getAAODDAppserverConfigFilePath();
            File aaodDDConfigFile = new File(AAOD_DDCONFIG_FILE_STR);
            String aaodKeystorePassEncrypted = null;
            if (aaodDDConfigFile.exists()) {
                Document ddconfigXMLDoc = POMSecurityUtils.getW3CDomDocument(aaodDDConfigFile);
                NodeList certificateInfoNodeList = ddconfigXMLDoc.getElementsByTagName("certificateInfo").item(0).getChildNodes();
                for (int j = 0; j < certificateInfoNodeList.getLength(); ++j) {
                    Node fstNode = certificateInfoNodeList.item(j);
                    if (1 != fstNode.getNodeType() || !"password".equals(fstNode.getNodeName())) continue;
                    Element fstElmnt = (Element)fstNode;
                    aaodKeystorePassEncrypted = fstElmnt.getAttribute("value");
                }
            }
            if (null != aaodKeystorePassEncrypted) {
                AAODSecurityCrypto aaodCrypto = new AAODSecurityCrypto();
                aaodKeystorePassDecrypted = new String(aaodCrypto.decrypt(aaodKeystorePassEncrypted.getBytes()));
            }
        }
        catch (Exception e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to retrieve AAOD Keystore Password", e);
        }
        return aaodKeystorePassDecrypted;
    }

    public static boolean updateAttributeOfElementInXML(String xmlFilePath, String element, String attribute, String newAttributeValue) {
        boolean isAttribFoundInAtLeaseOneElement = false;
        boolean isAttribUpdated = false;
        try {
            File xmlFile = new File(xmlFilePath);
            Document xmlDoc = POMSecurityUtils.getW3CDomDocument(xmlFile);
            NodeList nodeList = xmlDoc.getElementsByTagName(element);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elementNode;
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !(elementNode = (Element)node).hasAttribute(attribute)) continue;
                isAttribFoundInAtLeaseOneElement = true;
                elementNode.setAttribute(attribute, newAttributeValue);
            }
            if (isAttribFoundInAtLeaseOneElement) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource domSource = new DOMSource(xmlDoc);
                StreamResult xmlStreamResult = new StreamResult(xmlFile);
                transformer.transform(domSource, xmlStreamResult);
                isAttribUpdated = true;
            }
        }
        catch (Exception e) {
            POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Failed to update attribute [" + attribute + "] of an element [" + element + "] in xml file [" + xmlFilePath + "] ", e);
            isAttribUpdated = false;
        }
        return isAttribUpdated;
    }

    public static boolean isStringNullOrEmpty(String string) {
        return null == string || string.isEmpty();
    }

    public static boolean isDataValidForDecryption(String data, boolean isLoggingNeeded) {
        boolean isDataValid;
        block3: {
            isDataValid = false;
            if (!POMSecurityUtils.isStringNullOrEmpty(data)) {
                try {
                    ByteBuffer cipherText = ByteBuffer.wrap(Base64.getDecoder().decode(data));
                    cipherText.get(new byte[12]);
                    cipherText.get(new byte[cipherText.remaining()]);
                    isDataValid = true;
                }
                catch (Exception e) {
                    if (!isLoggingNeeded) break block3;
                    POMSecurityLogger.getConsoleLogger().log(Level.SEVERE, "Error: Data with value = {" + data + "} is not properly encrypted and cannot be decrypted : " + e.getMessage(), e);
                }
            }
        }
        return isDataValid;
    }
}

