/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.consumer;

import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import java.util.Collection;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;

public class ConsumerRebalanceImpl
implements ConsumerRebalanceListener {
    private Consumer<?, ?> consumer;
    private final boolean seekToEnd;

    public ConsumerRebalanceImpl(Consumer<?, ?> consumer, boolean seekToEnd) {
        this.consumer = consumer;
        this.seekToEnd = seekToEnd;
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            POMEventLoggerHolder.getInstance().fine("Parititiona assigned: " + partition);
        }
        if (this.seekToEnd) {
            POMEventLoggerHolder.getInstance().fine("Receive messages after client start");
            this.consumer.seekToEnd(partitions);
        } else {
            POMEventLoggerHolder.getInstance().fine("Receive message from last commit");
        }
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            POMEventLoggerHolder.getInstance().fine("Parititiona revoked : " + this.consumer.position(partition));
        }
    }
}

