/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.pim.eventsdk.rest;

import com.avaya.pim.eventsdk.common.GsonUtil;
import com.avaya.pim.eventsdk.core.LoginContext;
import com.avaya.pim.eventsdk.core.POMEventRegistrar;
import com.avaya.pim.eventsdk.exception.IPOMEventErrorCode;
import com.avaya.pim.eventsdk.exception.POMEventException;
import com.avaya.pim.eventsdk.logger.POMEventLoggerHolder;
import com.avaya.pim.eventsdk.rest.KafkaServerDto;
import com.avaya.pim.eventsdk.rest.UserCredential;
import com.avaya.pim.eventsdk.rest.UserDetail;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import sun.misc.BASE64Encoder;

public class RestUtil {
    private static final String POM_X_REQUESTED_WITH = "POMRest";
    private static String HTTPS = "https";
    private static String COLON = ":";
    private static String DOUBLE_FORWARD_SLASH = "//";
    private static String SINGLE_FORWARD_SLASH = "/";
    private static String POST_REQUEST_METHOD = "POST";
    private static String PUT_REQUEST_METHOD = "PUT";
    private static String GET_REQUEST_METHOD = "GET";
    private static String CONTENT_TYPE = "Content-Type";
    private static String CONTENT_TYPE_JSON = "application/json";
    private static volatile String USER_AUTHORIZATION_URN = "VP_POM_Service/v2/authorize";
    private static volatile String KAFKA_SERVER_URN = "VP_POM_Service/v3/kafkaserver/all";

    private static String makeRestRequest(String serverIPAddress, String urn, String data, String requestType, boolean isAuthenticationRequired) throws POMEventException {
        HttpURLConnection connection = null;
        InputStream stream = null;
        try {
            BufferedReader reader;
            String urlString = HTTPS + COLON + DOUBLE_FORWARD_SLASH + serverIPAddress + COLON + POMEventRegistrar.getInstance().getLoginOption().getPomPortNumber() + SINGLE_FORWARD_SLASH + urn;
            POMEventLoggerHolder.getInstance().finer("sending request :" + urlString);
            URL url = new URL(urlString);
            connection = (HttpsURLConnection)url.openConnection();
            ((HttpsURLConnection)connection).setSSLSocketFactory(POMEventRegistrar.getInstance().getLoginOption().getSslContext().getSocketFactory());
            connection.setRequestMethod(requestType);
            connection.setRequestProperty(CONTENT_TYPE, CONTENT_TYPE_JSON);
            connection.setRequestProperty("X-Requested-With", POM_X_REQUESTED_WITH);
            if (isAuthenticationRequired) {
                BASE64Encoder enc = new BASE64Encoder();
                String userpassword = LoginContext.getInstance().getUserName() + ":" + LoginContext.getInstance().getPassword();
                String encodedAuthorization = enc.encode(userpassword.getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
            }
            if (POST_REQUEST_METHOD.equals(requestType) || PUT_REQUEST_METHOD.equals(requestType)) {
                connection.setChunkedStreamingMode(8096);
                connection.setDoOutput(true);
                connection.connect();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
                writer.println(data);
                writer.flush();
            } else {
                connection.connect();
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                stream = connection.getInputStream();
                BufferedReader reader2 = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                StringBuilder response = new StringBuilder();
                String readline = null;
                while ((readline = reader2.readLine()) != null) {
                    POMEventLoggerHolder.getInstance().finer("Received Response: " + readline);
                    response.append(readline);
                }
                String string = response.toString();
                return string;
            }
            try {
                POMEventLoggerHolder.getInstance().fine("Failed to get response. " + responseCode);
                StringBuilder response = new StringBuilder();
                stream = connection.getErrorStream();
                if (stream != null) {
                    reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    String readline = null;
                    while ((readline = reader.readLine()) != null) {
                        POMEventLoggerHolder.getInstance().finest("Received Response: " + readline);
                        response.append(readline);
                    }
                }
                throw new POMEventException(IPOMEventErrorCode.FAILED_SERVICE_RESPONSE, response.toString());
            }
            catch (IOException e) {
                POMEventLoggerHolder.getInstance().error("Error while sending request ", e);
                StringBuilder response = new StringBuilder();
                if (connection != null) {
                    int respCode = 0;
                    try {
                        respCode = connection.getResponseCode();
                        InputStream errorStream = connection.getErrorStream();
                        if (errorStream != null) {
                            reader = new BufferedReader(new InputStreamReader(errorStream, "UTF-8"));
                            String readline = null;
                            while ((readline = reader.readLine()) != null) {
                                response.append(readline);
                            }
                            errorStream.close();
                        }
                    }
                    catch (IOException ex) {
                        POMEventLoggerHolder.getInstance().error("Error while reading error stream. Response code " + respCode, e);
                    }
                }
                throw new POMEventException(IPOMEventErrorCode.UNABLE_TO_CONNECT_TO_SERVER, response.toString());
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    POMEventLoggerHolder.getInstance().error("Error while closing stream ", e);
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void authorizeUser(String serverIPAddress, String userName, String password) throws POMEventException {
        try {
            UserCredential userCredential = new UserCredential();
            userCredential.setUserName(userName);
            userCredential.setPassword(password);
            String requestPayload = GsonUtil.getJson(userCredential);
            String response = RestUtil.makeRestRequest(serverIPAddress, USER_AUTHORIZATION_URN, requestPayload, POST_REQUEST_METHOD, false);
            UserDetail userDetail = GsonUtil.getObject(response, UserDetail.class);
            if (userDetail != null) {
                LoginContext loginContext = LoginContext.getInstance();
                loginContext.setPimUserId(userDetail.getPimUserId());
                loginContext.setOrgName(userDetail.getOrgName());
                loginContext.setUserName(userDetail.getUserName());
                loginContext.setPassword(password);
                String kafkTopicUrl = "VP_POM_Service/v4/kafka/getTopicList";
                String response1 = RestUtil.makeRestRequest(serverIPAddress, kafkTopicUrl, null, "GET", true);
                POMEventLoggerHolder.getInstance().fine("response received = " + response1);
                loginContext.setTopicsMap(GsonUtil.getObject(response1, Map.class));
                POMEventLoggerHolder.getInstance().fine("Login Context has been initialized " + loginContext);
            }
        }
        catch (POMEventException e) {
            if (IPOMEventErrorCode.FAILED_SERVICE_RESPONSE.equals(e.getErrorCode())) {
                throw new POMEventException(IPOMEventErrorCode.USER_NOT_AUTHORIZED, "User is not authenticated");
            }
            throw e;
        }
    }

    public static String getKafkaServerString(String serverIPAddress) throws POMEventException {
        try {
            String response = RestUtil.makeRestRequest(serverIPAddress, KAFKA_SERVER_URN, null, GET_REQUEST_METHOD, true);
            KafkaServerDto kafkaServerDto = GsonUtil.getObject(response, KafkaServerDto.class);
            if (kafkaServerDto != null) {
                return kafkaServerDto.getKafkaServerString();
            }
            POMEventLoggerHolder.getInstance().fine("Kafak server string response is null.");
            throw new POMEventException(IPOMEventErrorCode.UNABLE_TO_GET_KAFKA_SERVER_LIST, "Unable to retrieve kafka server list from POM Server");
        }
        catch (POMEventException e) {
            if (IPOMEventErrorCode.FAILED_SERVICE_RESPONSE.equals(e.getErrorCode())) {
                throw new POMEventException(IPOMEventErrorCode.UNABLE_TO_GET_KAFKA_SERVER_LIST, "Unable to retrieve kafka server list from POM Server");
            }
            throw e;
        }
    }

    public static void main(String[] args) throws POMEventException {
    }
}

