package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMImportStatisticsEventNotifier;
import com.avaya.pim.eventsdk.dto.job.ImportStatisticsEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMImportStatisticsEventNotifierImpl implements POMImportStatisticsEventNotifier
{
	private ILogger logger = null;


	public POMImportStatisticsEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("POM Event received ");
			if ((event instanceof ImportStatisticsEvent)
			    && (event.getEventTypeEnum() == EventTypeEnum.IMPORT_STATISTICS))
			{
				ImportStatisticsEvent statsEvent = (ImportStatisticsEvent) event;
				logger.finest("import statistics event received at : " + System.currentTimeMillis()
				              + " received object :" + statsEvent);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
