package com.avaya.pim.sampleclient;

import com.avaya.pim.eventsdk.core.*;
import com.avaya.pim.eventsdk.exception.POMEventException;
import com.avaya.pim.eventsdk.logger.ILogger;
import com.avaya.pim.sampleclient.logger.LoggerImpl;
import com.avaya.pim.sampleclient.notifier.*;

public class TestClient
{
	private static void printOnConsole(String msg)
	{
		System.out.println(msg); //NOSONAR
	}


	private static void exitFromApplication()
	{
		System.exit(0); //NOSONAR
	}


	public static void main(String[] args)
	{
		// POMEventRegistrar = POMEventFactory - ??
		try
		{
			if (args.length != 5)
			{
				printOnConsole("This Utility needs to run with follwoing 5 arguements.");
				printOnConsole("1. POM System User Name");
				printOnConsole("2. POM System User Password");
				printOnConsole("3. POM Server IP Address/Hostname");
				printOnConsole("4. POM Server Port Number. Usually the port is 443 ");
				printOnConsole("5. Subscription Option. Use number 2 for JOB, 4 for Agent, 8 for Job Statistics, 16 for Agent Statistics, 32 for Attempt, 64 for Enriched Attempt, 128 for Import Statistics, 256 for Hearbeat, 512 for Inbound Skill, 1024 for CCTRENDS."
				               + "You can sum up the number for multiple subscription i.e 6 for Job and Agent");
				exitFromApplication();
			}
			String loginName = args[0];
			String password = args[1];
			String pomIPAddress = args[2];
			int portNumber = 0;
			try
			{
				portNumber = Integer.parseInt(args[3]);
			} catch (NumberFormatException e)
			{
				printOnConsole("Please provide valid value for port number");
				exitFromApplication();
			}
			int subscriptionNumber = 0;
			try
			{
				subscriptionNumber = Integer.parseInt(args[4]);
				if (subscriptionNumber < 2)
				{
					printOnConsole("Please provide valid value for subscription");
					exitFromApplication();
				}
			} catch (NumberFormatException e)
			{
				printOnConsole("Please provide valid value for subscription");
				exitFromApplication();
			}
			printOnConsole("Starting Event SDK Client with loginName " + loginName + " pomIPAddress " + pomIPAddress
			               + " portNumber " + portNumber + " subscriptionOption  " + subscriptionNumber);
			POMEventRegistrar pomEventRegistrar = POMEventRegistrar.getInstance();
			ILogger logger = LoggerImpl.getTracer();
			pomEventRegistrar.login(loginName, password, pomIPAddress, logger, null /* LoginOptions */);
			// SSL Context or properties file
			if ((subscriptionNumber & 2) == 2)
			{
				POMJobEventNotifierImpl jobCallback = new POMJobEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.JOB, jobCallback);
			}
			if ((subscriptionNumber & 4) == 4)
			{
				POMAgentEventNotifierImpl agentCallback = new POMAgentEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.AGENT, agentCallback);
			}
			if ((subscriptionNumber & 8) == 8)
			{
				POMJobStatisticsEventNotifierImpl jobStatisticsCallback = new POMJobStatisticsEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.JOB_STATISTICS, jobStatisticsCallback);
			}
			if ((subscriptionNumber & 16) == 16)
			{
				POMAgentStatisticsEventNotifierImpl agentStatisticsCallback = new POMAgentStatisticsEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.AGENT_STATISTICS, agentStatisticsCallback);
			}
			if ((subscriptionNumber & 32) == 32)
			{
				POMAttemptEventNotifierImpl atemptResultCallback = new POMAttemptEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.ATTEMPT, atemptResultCallback);
			}
			if ((subscriptionNumber & 64) == 64)
			{
				POMEnrichedAttemptEventNotifierImpl enrichedAttemptResultCallback = new POMEnrichedAttemptEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.ENRICHED_ATTEMPT_RESULT, enrichedAttemptResultCallback);
			}
			if ((subscriptionNumber & 128) == 128)
			{
				POMImportStatisticsEventNotifierImpl importStatsResultCallback = new POMImportStatisticsEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.IMPORT_STATISTICS, importStatsResultCallback);
			}
			if ((subscriptionNumber & 256) == 256)
			{
				POMHeartBeatEventNotifier pomHeartBeatEventNotifier = new POMHeartBeatEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.HEART_BEAT, pomHeartBeatEventNotifier);
			}
			if ((subscriptionNumber & 512) == 512)
			{
				POMInboundSkillEventNotifier pomInboundSkillEventNotifier = new POMInboundSkillEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.INBOUND_SKILL, pomInboundSkillEventNotifier);
			}
			if ((subscriptionNumber & 1024) == 1024)
			{
				POMCCTrendEventNotifier pomccTrendEventNotifier = new POMCCTrendEventNotifierImpl(logger);
				pomEventRegistrar.subscribe(EventTypeEnum.CCTRENDS, pomccTrendEventNotifier);
			}
			pomEventRegistrar.initialize();
			while (true)
			{
				try
				{
					Thread.sleep(50 * 1000L);
				} catch (InterruptedException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		} catch (POMEventException e)
		{
			LoggerImpl.getTracer()
			          .error("POMException - Error Code " + e.getErrorCode() + " Error Messsage " + e.getErrorMessage(),
			                 e);
		}
	}
}
