package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMAgentStatisticsEventNotifier;
import com.avaya.pim.eventsdk.dto.agent.AgentStatisticsEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMAgentStatisticsEventNotifierImpl implements POMAgentStatisticsEventNotifier
{
	ILogger logger = null;


	public POMAgentStatisticsEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("Client received ");
			if (event.getEventTypeEnum() == EventTypeEnum.AGENT_STATISTICS)
			{
				AgentStatisticsEvent agentStatisticsEvent = (AgentStatisticsEvent) event;
				logger.finest("agent statistics event received at : " + System.currentTimeMillis()
				              + " received object :" + agentStatisticsEvent);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
