package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMAttemptEventNotifier;
import com.avaya.pim.eventsdk.dto.attempt.AttemptEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMAttemptEventNotifierImpl implements POMAttemptEventNotifier
{
	private ILogger logger = null;


	public POMAttemptEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("POM Event received ");
			if ((event instanceof AttemptEvent) && event.getEventTypeEnum() == EventTypeEnum.ATTEMPT)
			{
				AttemptEvent attemptEvent = (AttemptEvent) event;
				logger.finest("attempt event received at : " + System.currentTimeMillis() + " received object :"
				              + attemptEvent);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
