package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMEnrichedAttemptEventNotifier;
import com.avaya.pim.eventsdk.dto.attempt.EnrichedAttemptEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMEnrichedAttemptEventNotifierImpl implements POMEnrichedAttemptEventNotifier
{
	private ILogger logger = null;


	public POMEnrichedAttemptEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("POM Event received ");
			if ((event instanceof EnrichedAttemptEvent)
			    && (event.getEventTypeEnum() == EventTypeEnum.ENRICHED_ATTEMPT_RESULT))
			{
				EnrichedAttemptEvent enrichedAttemptEvent = (EnrichedAttemptEvent) event;
				logger.finest("enriched attempt event received at : " + System.currentTimeMillis()
				              + " received object :" + enrichedAttemptEvent);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
