package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMCCTrendEventNotifier;
import com.avaya.pim.eventsdk.dto.job.CCTrendEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMCCTrendEventNotifierImpl implements POMCCTrendEventNotifier
{
	ILogger logger = null;


	public POMCCTrendEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("Client received ");
			if (event.getEventTypeEnum() == EventTypeEnum.CCTRENDS)
			{
				CCTrendEvent ccTrendInfo = (CCTrendEvent) event;
				logger.finest("cc trends event received at : " + System.currentTimeMillis() + " received object :"
				              + ccTrendInfo);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
