package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMHeartBeatEventNotifier;
import com.avaya.pim.eventsdk.dto.heartbeat.HeartBeatEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMHeartBeatEventNotifierImpl implements POMHeartBeatEventNotifier
{
	ILogger logger = null;


	public POMHeartBeatEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("Client received ");
			if (event.getEventTypeEnum() == EventTypeEnum.HEART_BEAT)
			{
				HeartBeatEvent heartBeat = (HeartBeatEvent) event;
				logger.finest("heart beat event received at : " + System.currentTimeMillis() + " received object :"
				              + heartBeat);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
