package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMJobEventNotifier;
import com.avaya.pim.eventsdk.dto.job.IJobEventInfo.JobEventType;
import com.avaya.pim.eventsdk.dto.job.JobEvent;
import com.avaya.pim.eventsdk.dto.job.JobStateEventInfo;
import com.avaya.pim.eventsdk.dto.job.JobStateEventInfo.JobStateEventType;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMJobEventNotifierImpl implements POMJobEventNotifier
{
	ILogger logger = null;


	public POMJobEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("Client received ");
			if (event.getEventTypeEnum() == EventTypeEnum.JOB)
			{
				JobEvent jobInfo = (JobEvent) event;
				if (JobEventType.JobStateEvent.equals(jobInfo.getJobEventinfo().getJobEventType()))
				{
					JobStateEventInfo jobStateEventInfo = (JobStateEventInfo) jobInfo.getJobEventinfo();
					JobStateEventType jobStateEventType = jobStateEventInfo.getJobStateEventType();
					switch (jobStateEventType)
					{
						case JobQueuedEvent:
						case JobPauseEvent:
						case JobCompletedCreatingHistoryEvent:
						case JobStopEvent:
							logger.finest("generic event received at : " + System.currentTimeMillis()
							              + " received object :" + jobInfo);
							break;
						case JobRunningEvent:
							logger.finest("running event received at : " + System.currentTimeMillis()
							              + " received object :" + jobInfo);
							break;
						case JobCallbackEvent:
							logger.finest("callback event received at : " + System.currentTimeMillis()
							              + " received object :" + jobInfo);
							break;
						case JobCompletedEvent:
							logger.finest("completed event received at : " + System.currentTimeMillis()
							              + " received object :" + jobInfo);
							break;
						default:
							break;
					}
				}
				logger.finest("job event received at : " + System.currentTimeMillis() + " received object :" + jobInfo);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
