package com.avaya.pim.sampleclient.logger;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.apache.logging.log4j.spi.StandardLevel;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.Supplier;

/**
 * Extended Logger interface with convenience methods for
 * the FINE, FINER and FINEST custom log levels.
 * <p>Compatible with Log4j 2.6 or higher.</p>
 */
public final class LogLevel extends ExtendedLoggerWrapper
{
	private static final long serialVersionUID = 2195303572326200L;

	private final ExtendedLoggerWrapper logger;

	private static final String FQCN = com.avaya.pim.sampleclient.logger.LogLevel.class.getName();

	public static final Level FINE = Level.forName("FINE", 420);

	public static final Level FINER = Level.forName("FINER", 440);

	public static final Level FINEST = Level.forName("FINEST", 460);

	public static final Level OFF = Level.forName("OFF", StandardLevel.OFF.intLevel());

	public static final Level FATAL = Level.forName("FATAL", StandardLevel.FATAL.intLevel());

	public static final Level ERROR = Level.forName("ERROR", StandardLevel.ERROR.intLevel());

	public static final Level WARN = Level.forName("WARN", StandardLevel.WARN.intLevel());

	public static final Level INFO = Level.forName("INFO", StandardLevel.INFO.intLevel());

	public static final Level DEBUG = Level.forName("DEBUG", StandardLevel.DEBUG.intLevel());

	public static final Level TRACE = Level.forName("TRACE", StandardLevel.TRACE.intLevel());

	public static final Level ALL = Level.forName("ALL", StandardLevel.ALL.intLevel());


	private LogLevel(final Logger logger)
	{
		super((AbstractLogger) logger, logger.getName(), logger.getMessageFactory());
		this.logger = this;
	}


	/**
	 * Returns a custom Logger with the name of the calling class.
	 *
	 * @return The custom Logger for the calling class.
	 */
	public static com.avaya.pim.sampleclient.logger.LogLevel create()
	{
		final Logger wrapped = LogManager.getLogger();
		return new com.avaya.pim.sampleclient.logger.LogLevel(wrapped);
	}


	/**
	 * Returns a custom Logger using the fully qualified name of the Class as
	 * the Logger name.
	 *
	 * @param loggerName The Class whose name should be used as the Logger name.
	 *            If null it will default to the calling class.
	 * @return The custom Logger.
	 */
	public static com.avaya.pim.sampleclient.logger.LogLevel create(final Class<?> loggerName)
	{
		final Logger wrapped = LogManager.getLogger(loggerName);
		return new com.avaya.pim.sampleclient.logger.LogLevel(wrapped);
	}


	/**
	 * Returns a custom Logger using the fully qualified name of the Class as
	 * the Logger name.
	 *
	 * @param loggerName The Class whose name should be used as the Logger name.
	 *            If null it will default to the calling class.
	 * @param messageFactory The message factory is used only when creating a
	 *            logger, subsequent use does not change the logger but will log
	 *            a warning if mismatched.
	 * @return The custom Logger.
	 */
	public static com.avaya.pim.sampleclient.logger.LogLevel create(final Class<?> loggerName,
	                                                                final MessageFactory messageFactory)
	{
		final Logger wrapped = LogManager.getLogger(loggerName, messageFactory);
		return new com.avaya.pim.sampleclient.logger.LogLevel(wrapped);
	}


	/**
	 * Returns a custom Logger using the fully qualified class name of the value
	 * as the Logger name.
	 *
	 * @param value The value whose class name should be used as the Logger
	 *            name. If null the name of the calling class will be used as
	 *            the logger name.
	 * @return The custom Logger.
	 */
	public static com.avaya.pim.sampleclient.logger.LogLevel create(final Object value)
	{
		final Logger wrapped = LogManager.getLogger(value);
		return new com.avaya.pim.sampleclient.logger.LogLevel(wrapped);
	}


	/**
	 * Returns a custom Logger using the fully qualified class name of the value
	 * as the Logger name.
	 *
	 * @param value The value whose class name should be used as the Logger
	 *            name. If null the name of the calling class will be used as
	 *            the logger name.
	 * @param messageFactory The message factory is used only when creating a
	 *            logger, subsequent use does not change the logger but will log
	 *            a warning if mismatched.
	 * @return The custom Logger.
	 */
	public static com.avaya.pim.sampleclient.logger.LogLevel create(final Object value,
	                                                                final MessageFactory messageFactory)
	{
		final Logger wrapped = LogManager.getLogger(value, messageFactory);
		return new com.avaya.pim.sampleclient.logger.LogLevel(wrapped);
	}


	/**
	 * Returns a custom Logger with the specified name.
	 *
	 * @param name The logger name. If null the name of the calling class will
	 *            be used.
	 * @return The custom Logger.
	 */
	public static com.avaya.pim.sampleclient.logger.LogLevel create(final String name)
	{
		final Logger wrapped = LogManager.getLogger(name);
		return new com.avaya.pim.sampleclient.logger.LogLevel(wrapped);
	}


	/**
	 * Returns a custom Logger with the specified name.
	 *
	 * @param name The logger name. If null the name of the calling class will
	 *            be used.
	 * @param messageFactory The message factory is used only when creating a
	 *            logger, subsequent use does not change the logger but will log
	 *            a warning if mismatched.
	 * @return The custom Logger.
	 */
	public static com.avaya.pim.sampleclient.logger.LogLevel create(final String name,
	                                                                final MessageFactory messageFactory)
	{
		final Logger wrapped = LogManager.getLogger(name, messageFactory);
		return new com.avaya.pim.sampleclient.logger.LogLevel(wrapped);
	}


	/**
	 * Logs a message with the specific Marker at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msg the message string to be logged
	 */
	public void fine(final Marker marker, final Message msg)
	{
		logger.logIfEnabled(FQCN, FINE, marker, msg, (Throwable) null);
	}


	/**
	 * Logs a message with the specific Marker at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msg the message string to be logged
	 * @param t A Throwable or null.
	 */
	public void fine(final Marker marker, final Message msg, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, marker, msg, t);
	}


	/**
	 * Logs a message object with the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message object to log.
	 */
	public void fine(final Marker marker, final Object message)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message CharSequence with the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message CharSequence to log.
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker, final CharSequence message)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message at the {@code FINE} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void fine(final Marker marker, final Object message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, t);
	}


	/**
	 * Logs a message at the {@code FINE} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the CharSequence to log.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker, final CharSequence message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, t);
	}


	/**
	 * Logs a message object with the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message object to log.
	 */
	public void fine(final Marker marker, final String message)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param params parameters to the message.
	 * @see #getMessageFactory()
	 */
	public void fine(final Marker marker, final String message, final Object... params)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, params);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker, final String message, final Object p0)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker, final String message, final Object p0, final Object p1)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker, final String message, final Object p0, final Object p1, final Object p2)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker,
	                 final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2, p3);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker,
	                 final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2, p3, p4);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker,
	                 final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2, p3, p4, p5);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker,
	                 final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2, p3, p4, p5, p6);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker,
	                 final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6,
	                 final Object p7)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker,
	                 final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6,
	                 final Object p7,
	                 final Object p8)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @param p9 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final Marker marker,
	                 final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6,
	                 final Object p7,
	                 final Object p8,
	                 final Object p9)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	}


	/**
	 * Logs a message at the {@code FINE} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void fine(final Marker marker, final String message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, t);
	}


	/**
	 * Logs the specified Message at the {@code FINE} level.
	 *
	 * @param msg the message string to be logged
	 */
	public void fine(final Message msg)
	{
		logger.logIfEnabled(FQCN, FINE, null, msg, (Throwable) null);
	}


	/**
	 * Logs the specified Message at the {@code FINE} level.
	 *
	 * @param msg the message string to be logged
	 * @param t A Throwable or null.
	 */
	public void fine(final Message msg, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, null, msg, t);
	}


	/**
	 * Logs a message object with the {@code FINE} level.
	 *
	 * @param message the message object to log.
	 */
	public void fine(final Object message)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, (Throwable) null);
	}


	/**
	 * Logs a message at the {@code FINE} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void fine(final Object message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, t);
	}


	/**
	 * Logs a message CharSequence with the {@code FINE} level.
	 *
	 * @param message the message CharSequence to log.
	 * @since Log4j-2.6
	 */
	public void fine(final CharSequence message)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, (Throwable) null);
	}


	/**
	 * Logs a CharSequence at the {@code FINE} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the CharSequence to log.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.6
	 */
	public void fine(final CharSequence message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, t);
	}


	/**
	 * Logs a message object with the {@code FINE} level.
	 *
	 * @param message the message object to log.
	 */
	public void fine(final String message)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, (Throwable) null);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param params parameters to the message.
	 * @see #getMessageFactory()
	 */
	public void fine(final String message, final Object... params)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, params);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message, final Object p0)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message, final Object p0, final Object p1)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message, final Object p0, final Object p1, final Object p2)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message, final Object p0, final Object p1, final Object p2, final Object p3)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2, p3);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2, p3, p4);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2, p3, p4, p5);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2, p3, p4, p5, p6);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6,
	                 final Object p7)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2, p3, p4, p5, p6, p7);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6,
	                 final Object p7,
	                 final Object p8)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
	}


	/**
	 * Logs a message with parameters at the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @param p9 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void fine(final String message,
	                 final Object p0,
	                 final Object p1,
	                 final Object p2,
	                 final Object p3,
	                 final Object p4,
	                 final Object p5,
	                 final Object p6,
	                 final Object p7,
	                 final Object p8,
	                 final Object p9)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	}


	/**
	 * Logs a message at the {@code FINE} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void fine(final String message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the {@code FINE}level.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @since Log4j-2.4
	 */
	public void fine(final Supplier<?> msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINE, null, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINE}
	 * level) including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.4
	 */
	public void fine(final Supplier<?> msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, null, msgSupplier, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINE} level with the specified Marker.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @since Log4j-2.4
	 */
	public void fine(final Marker marker, final Supplier<?> msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINE, marker, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message with parameters which are only to be constructed if the logging level is the
	 * {@code FINE} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param paramSuppliers An array of functions, which when called, produce the desired log message parameters.
	 * @since Log4j-2.4
	 */
	public void fine(final Marker marker, final String message, final Supplier<?>... paramSuppliers)
	{
		logger.logIfEnabled(FQCN, FINE, marker, message, paramSuppliers);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINE}
	 * level) with the specified Marker and including the stack trace of the {@link Throwable}
	 * <code>t</code> passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @param t A Throwable or null.
	 * @since Log4j-2.4
	 */
	public void fine(final Marker marker, final Supplier<?> msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, marker, msgSupplier, t);
	}


	/**
	 * Logs a message with parameters which are only to be constructed if the logging level is
	 * the {@code FINE} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param paramSuppliers An array of functions, which when called, produce the desired log message parameters.
	 * @since Log4j-2.4
	 */
	public void fine(final String message, final Supplier<?>... paramSuppliers)
	{
		logger.logIfEnabled(FQCN, FINE, null, message, paramSuppliers);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINE} level with the specified Marker. The {@code MessageSupplier} may or may
	 * not use the {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @since Log4j-2.4
	 */
	public void fine(final Marker marker, final MessageSupplier msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINE, marker, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINE}
	 * level) with the specified Marker and including the stack trace of the {@link Throwable}
	 * <code>t</code> passed as parameter. The {@code MessageSupplier} may or may not use the
	 * {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @param t A Throwable or null.
	 * @since Log4j-2.4
	 */
	public void fine(final Marker marker, final MessageSupplier msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, marker, msgSupplier, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINE} level. The {@code MessageSupplier} may or may not use the
	 * {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @since Log4j-2.4
	 */
	public void fine(final MessageSupplier msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINE, null, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINE}
	 * level) including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 * The {@code MessageSupplier} may or may not use the {@link MessageFactory} to construct the
	 * {@code Message}.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.4
	 */
	public void fine(final MessageSupplier msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINE, null, msgSupplier, t);
	}


	/**
	 * Logs a message with the specific Marker at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msg the message string to be logged
	 */
	public void finer(final Marker marker, final Message msg)
	{
		logger.logIfEnabled(FQCN, FINER, marker, msg, (Throwable) null);
	}


	/**
	 * Logs a message with the specific Marker at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msg the message string to be logged
	 * @param t A Throwable or null.
	 */
	public void finer(final Marker marker, final Message msg, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, marker, msg, t);
	}


	/**
	 * Logs a message object with the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message object to log.
	 */
	public void finer(final Marker marker, final Object message)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message CharSequence with the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message CharSequence to log.
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker, final CharSequence message)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message at the {@code FINER} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finer(final Marker marker, final Object message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, t);
	}


	/**
	 * Logs a message at the {@code FINER} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the CharSequence to log.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker, final CharSequence message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, t);
	}


	/**
	 * Logs a message object with the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message object to log.
	 */
	public void finer(final Marker marker, final String message)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param params parameters to the message.
	 * @see #getMessageFactory()
	 */
	public void finer(final Marker marker, final String message, final Object... params)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, params);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker, final String message, final Object p0)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker, final String message, final Object p0, final Object p1)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker, final String message, final Object p0, final Object p1, final Object p2)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker,
	                  final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2, p3);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker,
	                  final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2, p3, p4);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker,
	                  final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2, p3, p4, p5);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker,
	                  final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2, p3, p4, p5, p6);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker,
	                  final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6,
	                  final Object p7)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker,
	                  final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6,
	                  final Object p7,
	                  final Object p8)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @param p9 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final Marker marker,
	                  final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6,
	                  final Object p7,
	                  final Object p8,
	                  final Object p9)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	}


	/**
	 * Logs a message at the {@code FINER} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finer(final Marker marker, final String message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, t);
	}


	/**
	 * Logs the specified Message at the {@code FINER} level.
	 *
	 * @param msg the message string to be logged
	 */
	public void finer(final Message msg)
	{
		logger.logIfEnabled(FQCN, FINER, null, msg, (Throwable) null);
	}


	/**
	 * Logs the specified Message at the {@code FINER} level.
	 *
	 * @param msg the message string to be logged
	 * @param t A Throwable or null.
	 */
	public void finer(final Message msg, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, null, msg, t);
	}


	/**
	 * Logs a message object with the {@code FINER} level.
	 *
	 * @param message the message object to log.
	 */
	public void finer(final Object message)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, (Throwable) null);
	}


	/**
	 * Logs a message at the {@code FINER} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finer(final Object message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, t);
	}


	/**
	 * Logs a message CharSequence with the {@code FINER} level.
	 *
	 * @param message the message CharSequence to log.
	 * @since Log4j-2.6
	 */
	public void finer(final CharSequence message)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, (Throwable) null);
	}


	/**
	 * Logs a CharSequence at the {@code FINER} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the CharSequence to log.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.6
	 */
	public void finer(final CharSequence message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, t);
	}


	/**
	 * Logs a message object with the {@code FINER} level.
	 *
	 * @param message the message object to log.
	 */
	public void finer(final String message)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, (Throwable) null);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param params parameters to the message.
	 * @see #getMessageFactory()
	 */
	public void finer(final String message, final Object... params)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, params);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message, final Object p0)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message, final Object p0, final Object p1)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message, final Object p0, final Object p1, final Object p2)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message, final Object p0, final Object p1, final Object p2, final Object p3)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2, p3);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2, p3, p4);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2, p3, p4, p5);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2, p3, p4, p5, p6);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6,
	                  final Object p7)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2, p3, p4, p5, p6, p7);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6,
	                  final Object p7,
	                  final Object p8)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
	}


	/**
	 * Logs a message with parameters at the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @param p9 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finer(final String message,
	                  final Object p0,
	                  final Object p1,
	                  final Object p2,
	                  final Object p3,
	                  final Object p4,
	                  final Object p5,
	                  final Object p6,
	                  final Object p7,
	                  final Object p8,
	                  final Object p9)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	}


	/**
	 * Logs a message at the {@code FINER} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finer(final String message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the {@code FINER}level.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @since Log4j-2.4
	 */
	public void finer(final Supplier<?> msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINER, null, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINER}
	 * level) including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.4
	 */
	public void finer(final Supplier<?> msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, null, msgSupplier, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINER} level with the specified Marker.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @since Log4j-2.4
	 */
	public void finer(final Marker marker, final Supplier<?> msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINER, marker, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message with parameters which are only to be constructed if the logging level is the
	 * {@code FINER} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param paramSuppliers An array of functions, which when called, produce the desired log message parameters.
	 * @since Log4j-2.4
	 */
	public void finer(final Marker marker, final String message, final Supplier<?>... paramSuppliers)
	{
		logger.logIfEnabled(FQCN, FINER, marker, message, paramSuppliers);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINER}
	 * level) with the specified Marker and including the stack trace of the {@link Throwable}
	 * <code>t</code> passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @param t A Throwable or null.
	 * @since Log4j-2.4
	 */
	public void finer(final Marker marker, final Supplier<?> msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, marker, msgSupplier, t);
	}


	/**
	 * Logs a message with parameters which are only to be constructed if the logging level is
	 * the {@code FINER} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param paramSuppliers An array of functions, which when called, produce the desired log message parameters.
	 * @since Log4j-2.4
	 */
	public void finer(final String message, final Supplier<?>... paramSuppliers)
	{
		logger.logIfEnabled(FQCN, FINER, null, message, paramSuppliers);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINER} level with the specified Marker. The {@code MessageSupplier} may or may
	 * not use the {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @since Log4j-2.4
	 */
	public void finer(final Marker marker, final MessageSupplier msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINER, marker, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINER}
	 * level) with the specified Marker and including the stack trace of the {@link Throwable}
	 * <code>t</code> passed as parameter. The {@code MessageSupplier} may or may not use the
	 * {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @param t A Throwable or null.
	 * @since Log4j-2.4
	 */
	public void finer(final Marker marker, final MessageSupplier msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, marker, msgSupplier, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINER} level. The {@code MessageSupplier} may or may not use the
	 * {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @since Log4j-2.4
	 */
	public void finer(final MessageSupplier msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINER, null, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINER}
	 * level) including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 * The {@code MessageSupplier} may or may not use the {@link MessageFactory} to construct the
	 * {@code Message}.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.4
	 */
	public void finer(final MessageSupplier msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINER, null, msgSupplier, t);
	}


	/**
	 * Logs a message with the specific Marker at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msg the message string to be logged
	 */
	public void finest(final Marker marker, final Message msg)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, msg, (Throwable) null);
	}


	/**
	 * Logs a message with the specific Marker at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msg the message string to be logged
	 * @param t A Throwable or null.
	 */
	public void finest(final Marker marker, final Message msg, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, msg, t);
	}


	/**
	 * Logs a message object with the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message object to log.
	 */
	public void finest(final Marker marker, final Object message)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message CharSequence with the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message CharSequence to log.
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker, final CharSequence message)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message at the {@code FINEST} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finest(final Marker marker, final Object message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, t);
	}


	/**
	 * Logs a message at the {@code FINEST} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the CharSequence to log.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker, final CharSequence message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, t);
	}


	/**
	 * Logs a message object with the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message object to log.
	 */
	public void finest(final Marker marker, final String message)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, (Throwable) null);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param params parameters to the message.
	 * @see #getMessageFactory()
	 */
	public void finest(final Marker marker, final String message, final Object... params)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, params);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker, final String message, final Object p0)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker, final String message, final Object p0, final Object p1)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker, final String message, final Object p0, final Object p1, final Object p2)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker,
	                   final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2, p3);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker,
	                   final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2, p3, p4);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker,
	                   final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2, p3, p4, p5);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker,
	                   final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2, p3, p4, p5, p6);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker,
	                   final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6,
	                   final Object p7)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker,
	                   final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6,
	                   final Object p7,
	                   final Object p8)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @param p9 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final Marker marker,
	                   final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6,
	                   final Object p7,
	                   final Object p8,
	                   final Object p9)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	}


	/**
	 * Logs a message at the {@code FINEST} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finest(final Marker marker, final String message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, t);
	}


	/**
	 * Logs the specified Message at the {@code FINEST} level.
	 *
	 * @param msg the message string to be logged
	 */
	public void finest(final Message msg)
	{
		logger.logIfEnabled(FQCN, FINEST, null, msg, (Throwable) null);
	}


	/**
	 * Logs the specified Message at the {@code FINEST} level.
	 *
	 * @param msg the message string to be logged
	 * @param t A Throwable or null.
	 */
	public void finest(final Message msg, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, null, msg, t);
	}


	/**
	 * Logs a message object with the {@code FINEST} level.
	 *
	 * @param message the message object to log.
	 */
	public void finest(final Object message)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, (Throwable) null);
	}


	/**
	 * Logs a message at the {@code FINEST} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finest(final Object message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, t);
	}


	/**
	 * Logs a message CharSequence with the {@code FINEST} level.
	 *
	 * @param message the message CharSequence to log.
	 * @since Log4j-2.6
	 */
	public void finest(final CharSequence message)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, (Throwable) null);
	}


	/**
	 * Logs a CharSequence at the {@code FINEST} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the CharSequence to log.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.6
	 */
	public void finest(final CharSequence message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, t);
	}


	/**
	 * Logs a message object with the {@code FINEST} level.
	 *
	 * @param message the message object to log.
	 */
	public void finest(final String message)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, (Throwable) null);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param params parameters to the message.
	 * @see #getMessageFactory()
	 */
	public void finest(final String message, final Object... params)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, params);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message, final Object p0)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message, final Object p0, final Object p1)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message, final Object p0, final Object p1, final Object p2)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message, final Object p0, final Object p1, final Object p2, final Object p3)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2, p3);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2, p3, p4);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2, p3, p4, p5);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2, p3, p4, p5, p6);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6,
	                   final Object p7)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2, p3, p4, p5, p6, p7);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6,
	                   final Object p7,
	                   final Object p8)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
	}


	/**
	 * Logs a message with parameters at the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param p0 parameter to the message.
	 * @param p1 parameter to the message.
	 * @param p2 parameter to the message.
	 * @param p3 parameter to the message.
	 * @param p4 parameter to the message.
	 * @param p5 parameter to the message.
	 * @param p6 parameter to the message.
	 * @param p7 parameter to the message.
	 * @param p8 parameter to the message.
	 * @param p9 parameter to the message.
	 * @see #getMessageFactory()
	 * @since Log4j-2.6
	 */
	public void finest(final String message,
	                   final Object p0,
	                   final Object p1,
	                   final Object p2,
	                   final Object p3,
	                   final Object p4,
	                   final Object p5,
	                   final Object p6,
	                   final Object p7,
	                   final Object p8,
	                   final Object p9)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	}


	/**
	 * Logs a message at the {@code FINEST} level including the stack trace of
	 * the {@link Throwable} {@code t} passed as parameter.
	 *
	 * @param message the message to log.
	 * @param t the exception to log, including its stack trace.
	 */
	public void finest(final String message, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the {@code FINEST}level.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @since Log4j-2.4
	 */
	public void finest(final Supplier<?> msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINEST, null, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINEST}
	 * level) including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.4
	 */
	public void finest(final Supplier<?> msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, null, msgSupplier, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINEST} level with the specified Marker.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @since Log4j-2.4
	 */
	public void finest(final Marker marker, final Supplier<?> msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message with parameters which are only to be constructed if the logging level is the
	 * {@code FINEST} level.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param message the message to log; the format depends on the message factory.
	 * @param paramSuppliers An array of functions, which when called, produce the desired log message parameters.
	 * @since Log4j-2.4
	 */
	public void finest(final Marker marker, final String message, final Supplier<?>... paramSuppliers)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, message, paramSuppliers);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINEST}
	 * level) with the specified Marker and including the stack trace of the {@link Throwable}
	 * <code>t</code> passed as parameter.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message;
	 *            the format depends on the message factory.
	 * @param t A Throwable or null.
	 * @since Log4j-2.4
	 */
	public void finest(final Marker marker, final Supplier<?> msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, msgSupplier, t);
	}


	/**
	 * Logs a message with parameters which are only to be constructed if the logging level is
	 * the {@code FINEST} level.
	 *
	 * @param message the message to log; the format depends on the message factory.
	 * @param paramSuppliers An array of functions, which when called, produce the desired log message parameters.
	 * @since Log4j-2.4
	 */
	public void finest(final String message, final Supplier<?>... paramSuppliers)
	{
		logger.logIfEnabled(FQCN, FINEST, null, message, paramSuppliers);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINEST} level with the specified Marker. The {@code MessageSupplier} may or may
	 * not use the {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @since Log4j-2.4
	 */
	public void finest(final Marker marker, final MessageSupplier msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINEST}
	 * level) with the specified Marker and including the stack trace of the {@link Throwable}
	 * <code>t</code> passed as parameter. The {@code MessageSupplier} may or may not use the
	 * {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param marker the marker data specific to this log statement
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @param t A Throwable or null.
	 * @since Log4j-2.4
	 */
	public void finest(final Marker marker, final MessageSupplier msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, marker, msgSupplier, t);
	}


	/**
	 * Logs a message which is only to be constructed if the logging level is the
	 * {@code FINEST} level. The {@code MessageSupplier} may or may not use the
	 * {@link MessageFactory} to construct the {@code Message}.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @since Log4j-2.4
	 */
	public void finest(final MessageSupplier msgSupplier)
	{
		logger.logIfEnabled(FQCN, FINEST, null, msgSupplier, (Throwable) null);
	}


	/**
	 * Logs a message (only to be constructed if the logging level is the {@code FINEST}
	 * level) including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 * The {@code MessageSupplier} may or may not use the {@link MessageFactory} to construct the
	 * {@code Message}.
	 *
	 * @param msgSupplier A function, which when called, produces the desired log message.
	 * @param t the exception to log, including its stack trace.
	 * @since Log4j-2.4
	 */
	public void finest(final MessageSupplier msgSupplier, final Throwable t)
	{
		logger.logIfEnabled(FQCN, FINEST, null, msgSupplier, t);
	}


	public void log(String fqdn, Level level, String message, Throwable t)
	{
		logger.logIfEnabled(fqdn, level, null, message, t);
	}


	public static Level toLevel(String level)
	{
		return Level.forName(level, -1);
	}


	public static String toString(Level level)
	{
		return level.toString();
	}
}
