package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMAgentEventNotifier;
import com.avaya.pim.eventsdk.dto.agent.AgentEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMAgentEventNotifierImpl implements POMAgentEventNotifier
{
	ILogger logger = null;


	public POMAgentEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("Client received ");
			if (event.getEventTypeEnum() == EventTypeEnum.AGENT)
			{
				AgentEvent agentEvent = (AgentEvent) event;
				logger.finest("agent event received at : " + System.currentTimeMillis() + " received object :"
				              + agentEvent);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
