package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMInboundSkillEventNotifier;
import com.avaya.pim.eventsdk.dto.skill.InboundSkillEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMInboundSkillEventNotifierImpl implements POMInboundSkillEventNotifier
{
	ILogger logger = null;


	public POMInboundSkillEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("Client received ");
			if (event.getEventTypeEnum() == EventTypeEnum.INBOUND_SKILL)
			{
				InboundSkillEvent inboundSkillInfo = (InboundSkillEvent) event;
				logger.finest("inbound skill event received at : " + System.currentTimeMillis() + " received object :"
				              + inboundSkillInfo);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
