package com.avaya.pim.sampleclient.notifier;

import com.avaya.pim.eventsdk.core.Event;
import com.avaya.pim.eventsdk.core.EventTypeEnum;
import com.avaya.pim.eventsdk.core.POMJobStatisticsEventNotifier;
import com.avaya.pim.eventsdk.dto.job.JobStatisticsEvent;
import com.avaya.pim.eventsdk.logger.ILogger;

public class POMJobStatisticsEventNotifierImpl implements POMJobStatisticsEventNotifier
{
	ILogger logger = null;


	public POMJobStatisticsEventNotifierImpl(ILogger logger)
	{
		this.logger = logger;
	}


	@Override
	public void onEvent(Event event)
	{
		try
		{
			logger.finest("Client received ");
			if (event.getEventTypeEnum() == EventTypeEnum.JOB_STATISTICS)
			{
				JobStatisticsEvent jobStatisticsInfo = (JobStatisticsEvent) event;
				logger.finest("job statistics event received at : " + System.currentTimeMillis() + " received object :"
				              + jobStatisticsInfo);
			}
		} catch (Exception e)
		{
			logger.error("Error", e);
		}
	}
}
