package com.avaya.pim.recorder;

/*
* POMRecorderSampleClient.java
* 
 * Copyright (c) 2015-2020 Avaya Inc. All rights reserved.
* 
 * USE OR INSTALLATION OF THIS SAMPLE DEMONSTRATION SOFTWARE INDICATES THE END
* USERS ACCEPTANCE OF THE GENERAL LICENSE TERMS AVAILABLE ON THE AVAYA WEBSITE
* AT http://support.avaya.com/LicenseInfo/ (GENERAL LICENSE TERMS). DO NOT USE
* THE SOFTWARE IF YOU DO NOT WISH TO BE BOUND BY THE GENERAL LICENSE TERMS. IN
* ADDITION TO THE GENERAL LICENSE TERMS, THE FOLLOWING ADDITIONAL TERMS AND
* RESTRICTIONS WILL TAKE PRECEDENCE AND APPLY TO THIS DEMONSTRATION SOFTWARE.
* 
 * THIS DEMONSTRATION SOFTWARE IS PROVIDED FOR THE SOLE PURPOSE OF DEMONSTRATING
* HOW TO USE THE SOFTWARE DEVELOPMENT KIT AND MAY NOT BE USED IN A LIVE OR
* PRODUCTION ENVIRONMENT. THIS DEMONSTRATION SOFTWARE IS PROVIDED ON AN AS IS
* BASIS, WITHOUT ANY WARRANTIES OR REPRESENTATIONS EXPRESS, IMPLIED, OR
* STATUTORY, INCLUDING WITHOUT LIMITATION, WARRANTIES OF QUALITY, PERFORMANCE,
* INFRINGEMENT, MERCHANTABILITY, OR FITNESS FOR A PARTICULAR PURPOSE.
* 
 * EXCEPT FOR PERSONAL INJURY CLAIMS, WILLFUL MISCONDUCT AND END USERS VIOLATION
* OF AVAYA OR ITS SUPPLIERS INTELLECTUAL PROPERTY RIGHTS, INCLUDING THROUGH A
* BREACH OF THE SOFTWARE LICENSE, NEITHER AVAYA, ITS SUPPLIERS NOR END USER
* SHALL BE LIABLE FOR (i) ANY INCIDENTAL, SPECIAL, STATUTORY, INDIRECT OR
* CONSEQUENTIAL DAMAGES, OR FOR ANY LOSS OF PROFITS, REVENUE, OR DATA, TOLL
* FRAUD, OR COST OF COVER AND (ii) DIRECT DAMAGES ARISING UNDER THIS AGREEMENT
* IN EXCESS OF FIFTY DOLLARS (U.S. $50.00).
* 
 * To the extent there is a conflict between the General License Terms, your
* Customer Sales Agreement and the terms and restrictions set forth herein, the
* terms and restrictions set forth herein shall prevail solely for this Utility
* Demonstration Software.
*/


import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.util.Properties;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class POMRecorderSampleClient {

	public POMRecorderSampleClient() {
		
	}
	static Socket connection = null;
	public static int READ_LENGTH = 6;
	
	/*
	 * Please Modify the properties file before running the sample client.	 
	 */
	
	public static void main(String[] args) {    

	    try {	  
	    	
	    	Properties prop = new Properties();
			String propFileName = System.getProperty("user.dir")+"/config.properties";
 
			InputStream inputStream = new FileInputStream(propFileName);
 
			prop.load(inputStream);			
 
			// get the property value and print it out
			String ipaddress = prop.getProperty("POM-ipaddress");
			String username = prop.getProperty("username");
			String password = prop.getProperty("password");
			String zone = prop.getProperty("zone");
			String issecured = prop.getProperty("issecured");
			String certificate_path = prop.getProperty("certificate_path");
			String storepassword = prop.getProperty("storepassword");
			int port = prop.getProperty("port") != null ? new Integer(prop.getProperty("port")):-1;
			
			if(port == -1){
				System.out.println("Please provide a valid port number");				
			}
			
			System.out.println(ipaddress +" "+username +" "+zone +" "+issecured +" "+certificate_path +" "+port);
	      InetAddress address = InetAddress.getByName(ipaddress);	 
	      
	      //TODO: if issecured prop value is 'secured' - make connection using TLS, else if value is 'none' - continue with current approach
	      if(issecured != null && username != null&& password != null&& zone != null)
	      {
	    	  if("secured".equalsIgnoreCase(issecured))
		      {
		    	  System.out.println("Secured connection request");
		    	  
		    	  //create socket using TLS		    	 
		    	  if(certificate_path != null && storepassword != null)
		    	  {		    		 
			    	  SSLContext sslContext = getSSLContext(certificate_path,storepassword);
			    	  if(sslContext != null)
			    	  {
			    		  connection = sslContext.getSocketFactory().createSocket(address, port);
			    	  }
			    	  else
			    	  {
			    		  System.out.println("Failed to establish secured connection. Please retry.");
			    	  }
		    	  }
		    	  else
		    	  {
		    		  System.out.println("Invalid input. Simulator accepts either of the below 2 input formats.");
			    	  System.out.println("<POM-ipaddress> <username> <password> <zone> <secured> <certificate_path><store-password>");
			    	  System.out.println("<POM-ipaddress> <username> <password> <zone> <none>");
			    	  return; 
		    	  }
		    	  
		      }
		      else
		      {
		    	  System.out.println("Unsecured connection request");
		    	  connection = new Socket(address, port);
		      }
	      }
	      else
	      {
	    	  System.out.println("Invalid input. Simulator accepts either of the below 2 input formats.");
	    	  System.out.println("<POM-ipaddress> <username> <password> <zone> <secured> <certificate_path><store-password>");
	    	  System.out.println("<POM-ipaddress> <username> <password> <zone> <none>");
	    	  return;
	      }
	      
	      //BufferedOutputStream bos = new BufferedOutputStream(connection.getOutputStream());
	      if(connection == null)
	      {
	    	  System.out.println("Failed to establish connection");
	    	  return;
	      }
	      
	      InputStream in = connection.getInputStream();
		  OutputStream out = connection.getOutputStream();
	      String loginReq = "<LoginRequest pumpup=\"true\"><user>"+ username +"</user><password>"+password+"</password><zone>"+zone +"</zone></LoginRequest>";
	      System.out.println("Lenght : "+getUTF8BytesLen(loginReq));
	      out.write((getUTF8BytesLen(loginReq)+loginReq).getBytes("UTF-8"));
	      System.out.println((getUTF8BytesLen(loginReq)+loginReq));
	      out.flush();      

	      while (true ){       
	          try{

	        	  byte[] bufferlen = new byte[READ_LENGTH];
					in.read(bufferlen, 0, READ_LENGTH);
					String strMessage = new String(bufferlen,"UTF-8");
					int len = getLength(strMessage);
					if(len > 0)
					{
						byte[] buffer = new byte[len];
						int c = 0;
						while (c < len){
							c += in.read(buffer, 0, len);
							System.out.println(new String(buffer,"UTF-8"));
						}
					}
	          }catch (Exception g) {
		          System.out.println("Exception: " + g);
		          g.printStackTrace();
		          //connection.close();
		          break;
		        }
	          
	      }
	    } catch (IOException f) {
	          System.out.println("IOException: " + f);
	          f.printStackTrace();
	     
	        }
	        catch (Exception g) {
	          System.out.println("Exception: " + g);
	          g.printStackTrace();
	          
	        }
	    finally {
			if(connection !=null )
			{
				try {
					connection.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}

	public static String getUTF8BytesLen(String s) {
		try {
			final byte[] utf8Bytes = s.getBytes("UTF-8");
			String len = String.format("%0"+READ_LENGTH+"d", utf8Bytes.length);
			return len;
		} catch (Exception e) {
			System.out.println("Error :"+ e.getMessage());
			
			e.printStackTrace();
			return "";
		}
	}
	
	private static int getLength(String length)
	{
		int len = 0;
		try
		{
			len = Integer.parseInt(length);
		}
		catch(NumberFormatException e)
		{
			//System.out.println("Invalid length"+ length);
			//e.printStackTrace();
		}
		return len;
	}
	
	private static SSLContext getSSLContext(String trustStore, String password)
	{
		FileInputStream stream = null;
		try
		{
			System.out.println("Received cert File path: " + trustStore);
			char[] passphrase = password.toCharArray();
			KeyStore ks = KeyStore.getInstance("JKS");
			stream = new FileInputStream(trustStore);
			ks.load(stream, passphrase);
			KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
			kmf.init(ks, passphrase);
			TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
			tmf.init(ks);
			SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
			sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
			stream.close();
			return sslContext;
		} catch (Exception e)
		{
			System.out.println("Exception in getSSLContext.");
			e.printStackTrace();
			return null;
		} finally
		{
			try
			{
				if (stream != null)
					stream.close();
			} catch (IOException e)
			{
				e.printStackTrace();
			}
		}
	}
}
