// Adjust your package name to fit your environment.
package com.avaya.sslvpn;

// Add this import:
//import com.avaya.sslvpn;

import java.security.PublicKey;

public class OnboardingHelloWorld
{
    private static String INVENTORY_FILE = "examples/inventory.xml";
    private static String PUBLIC_KEY_FILE = "examples/public_key.txt";
    private static String PROPERTIES_FILE = "templates/sslvpn.properties";
    private static String XML_TEMPLATE_FILE = "templates/sslvpn_template.xml";
    private static String HELLO_WORLD_FILE1 = "examples/hello_world_onboarding1.xml";
    private static String HELLO_WORLD_FILE2 = "examples/hello_world_onboarding2.xml";

    public static void main(String[] args)
    {
        try
        {
            PublicKey publicKey = sslvpnOnboarding.initPubKey(INVENTORY_FILE, null);

            if (publicKey != null)
            {
                sslvpnOnboarding
                        .generateSSLVPN(publicKey, XML_TEMPLATE_FILE, HELLO_WORLD_FILE1, PROPERTIES_FILE, false);
                System.out.println(SSLVPN_RESULT.SUCCESS);
            }
            else
            {
                System.out.println("The public key could not be parsed.");
            }
            
            publicKey = sslvpnOnboarding.initPubKey(null, PUBLIC_KEY_FILE);

            if (publicKey != null)
            {
                sslvpnOnboarding
                        .generateSSLVPN(publicKey, XML_TEMPLATE_FILE, HELLO_WORLD_FILE2, PROPERTIES_FILE, false);
                System.out.println(SSLVPN_RESULT.SUCCESS);
            }
            else
            {
                System.out.println("The public key could not be parsed.");
            }
        }
        catch (sslvpnException e)
        {
            System.out.println(e.getMessage());
            System.out.println(e.getError());
        }
        catch (Exception e)
        {
            System.out.println(e.getMessage());
        }
    }
}
