/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sslvpn;

import com.avaya.sslvpn.Base64Utils;
import com.avaya.sslvpn.SSLVPNProps;
import com.avaya.sslvpn.SSLVPN_RESULT;
import com.avaya.sslvpn.sslvpnException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class sslvpnOnboarding {
    private static final String CHARSET = "UTF-8";
    public static String PROP_FILE_ID = "-p";
    public static String TEMPLATE_FILE_ID = "-t";
    public static String INVENTORY_FILE_ID = "-i";
    public static String KEY_FILE_ID = "-k";
    public static String OUTPUT_FILE_ID = "-o";
    public static String NO_SIGN_ID = "-nosign";
    private static String DATE_TAG = "datestamp";
    private static String SERVICE_TAG = "Service";
    private static String SERVICE_NAME_TAG = "Name";
    private static String SNMP_TAG = "SNMP";
    private static String WS_OBJECT_TAG = "ws_object";
    private static String SHORTCODE_TAG = "ShortCode";
    private static String SHORTCODE_TEL_NUMBER_TAG = "TelephoneNumber";
    private static String IPROUTE_TAG = "IPRoute";
    private static String IPROUTE_DESTINATION_TAG = "Destination";
    private static boolean serviceMode = false;
    private static boolean shortcodeMode = false;
    private static boolean iprouteMode = false;
    private static boolean propertiesSupported = false;
    private static String tagPrefix = null;
    private static String MANDATORY_SOLDTO = "soldto";
    private static String MANDATORY_FORMATVERSION = "formatversion";
    private static String MANDATORY_SERVICE_ACCT_NAME = "AccountName";
    private static int MANDATORY_SERVICE_ACCT_NAME_LEN = 33;
    private static String MANDATORY_SERVICE_ACCT_PASSWORD = "Password";
    private static int MANDATORY_SERVICE_ACCT_PASSWORD_LEN = 31;
    private static String OPTIONAL_SERVER_ADDRESS = "ServerAddress";
    private static int OPTIONAL_SERVER_ADDRESS_LEN = 33;
    private static String OPTIONAL_SESSION_MODE = "SessionMode";
    private static String OPTIONAL_INFALLBBACK = "InFallBack";
    private static String OPTIONAL_SNMP_DEVICEID = "SNMP@DeviceID";
    private static int OPTIONAL_SNMP_DEVICEID_LEN = 10;
    private static byte[] passwordHash = null;
    public static boolean noSign = false;
    private static String IDENTITY_CERTS_TAG = "IdentityCertificates";
    private static String IDENTITY_CERT_TAG = "IdentityCertificate";
    private static String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static String END_CERT = "-----END CERTIFICATE-----";

    private sslvpnOnboarding() {
    }

    private static String readKeyFile(String string) throws sslvpnException {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            while (fileInputStream.available() > 0) {
                char c = (char)fileInputStream.read();
                stringBuffer.append(c);
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new sslvpnException(SSLVPN_RESULT.UNABLE_TO_OPEN_KEY_FILE, "Unable to load key file");
        }
        catch (IOException iOException) {
            throw new sslvpnException(SSLVPN_RESULT.UNABLE_TO_OPEN_KEY_FILE, "Unable to load key file");
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new sslvpnException(SSLVPN_RESULT.UNABLE_TO_OPEN_KEY_FILE, "Unable to load key file");
            }
        }
    }

    private static Element findDefaultIdentityCertificate(Element element) {
        NodeList nodeList = element.getElementsByTagName(IDENTITY_CERTS_TAG);
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        if (element2 != null) {
            NodeList nodeList2 = element2.getElementsByTagName(IDENTITY_CERT_TAG);
            if (nodeList2.getLength() == 0) {
                return null;
            }
            Element element3 = null;
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                element3 = (Element)nodeList2.item(i);
                String string = element3.getAttribute("type");
                if (!string.equalsIgnoreCase("DefaultIdentityCertificate")) continue;
                return element3;
            }
        }
        return null;
    }

    public static PublicKey initPubKey(String string, String string2) throws UnsupportedEncodingException {
        Object object;
        Object object2;
        Object object3;
        String string3 = null;
        PublicKey publicKey = null;
        if (string != null) {
            object3 = DocumentBuilderFactory.newInstance();
            object2 = null;
            try {
                object = ((DocumentBuilderFactory)object3).newDocumentBuilder();
                object2 = ((DocumentBuilder)object).parse(string);
            }
            catch (IOException iOException) {
                System.out.println("Could not open file:'" + string + "'");
                System.out.println(SSLVPN_RESULT.UNABLE_TO_OPEN_INV_FILE);
                return null;
            }
            catch (Exception exception) {
                System.out.println("Could not load inventory file:'" + string + "'");
                System.out.println(SSLVPN_RESULT.INVALID_INV_FILE);
                return null;
            }
            object = sslvpnOnboarding.findDefaultIdentityCertificate(object2.getDocumentElement());
            if (object == null) {
                System.out.println("Inventory file does not contain the default IDENTITY certificate");
                System.out.println(SSLVPN_RESULT.ID_CERT_NOT_FOUND);
                return null;
            }
            Node node = object.getFirstChild();
            if (node == null) {
                System.out.println("Inventory file does not contain the IDENTITY certificate");
                System.out.println(SSLVPN_RESULT.ID_CERT_NOT_FOUND);
                return null;
            }
            string3 = ((Text)node).getData().trim();
        } else if (string2 != null) {
            try {
                string3 = sslvpnOnboarding.readKeyFile(string2);
            }
            catch (sslvpnException sslvpnException2) {
                System.out.println(sslvpnException2.getMessage());
                System.out.println(sslvpnException2.getError());
                return null;
            }
        }
        if (string3 != null) {
            if (!string3.startsWith(BEGIN_CERT)) {
                System.out.println("Certifcate data does not start with:" + BEGIN_CERT);
                System.out.println(SSLVPN_RESULT.INVALID_ID_CERT);
                return null;
            }
            if (!string3.endsWith(END_CERT)) {
                System.out.println("Certifcate data does not end with:" + END_CERT);
                System.out.println(SSLVPN_RESULT.INVALID_ID_CERT);
                return null;
            }
            try {
                object3 = CertificateFactory.getInstance("X.509");
                object2 = new ByteArrayInputStream(string3.getBytes(CHARSET));
                object = (X509Certificate)((CertificateFactory)object3).generateCertificate((InputStream)object2);
                publicKey = ((Certificate)object).getPublicKey();
            }
            catch (CertificateException certificateException) {
                System.out.println("cert exception: " + certificateException.getMessage() + "Cause:" + certificateException.getCause());
                return null;
            }
            return publicKey;
        }
        System.out.println("Invalid IDENTITY certificate");
        System.out.println(SSLVPN_RESULT.INVALID_ID_CERT);
        return null;
    }

    private static String encryptRSA(PublicKey publicKey, String string) throws sslvpnException, UnsupportedEncodingException {
        String string2 = null;
        if (publicKey == null) {
            throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "missing public key");
        }
        if (!noSign) {
            try {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, publicKey);
                byte[] byArray = string.getBytes(CHARSET);
                byte[] byArray2 = new byte[byArray.length + 1];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray2[i] = byArray[i];
                }
                byArray2[byArray.length] = 0;
                byte[] byArray3 = cipher.doFinal(byArray2);
                string2 = Base64Utils.encodeToString(byArray3);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "error during encryption(blocksize)");
            }
            catch (BadPaddingException badPaddingException) {
                throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "error during encryption(badpadding)");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "error during encryption(algorithm)");
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "error during encryption(nosuchpadding)");
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "error during encryption(key)");
            }
        }
        return string2;
    }

    private static void updatedoc(PublicKey publicKey, Node node, SSLVPNProps sSLVPNProps, boolean bl) throws sslvpnException, UnsupportedEncodingException {
        if (publicKey == null) {
            throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "missing public key");
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            int n;
            Object object;
            Object object2;
            Object object3;
            if (node2.getNodeType() != 1) continue;
            String string = null;
            String string2 = node2.getNodeName();
            if (MANDATORY_FORMATVERSION.equals(string2)) {
                string = "2";
            } else if (DATE_TAG.equals(string2)) {
                object3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                ((DateFormat)object3).setTimeZone(TimeZone.getTimeZone("GMT"));
                string = ((DateFormat)object3).format(new Date());
            } else if (SERVICE_TAG.equals(string2)) {
                serviceMode = true;
            } else if (SHORTCODE_TAG.equals(string2)) {
                shortcodeMode = true;
            } else if (IPROUTE_TAG.equals(string2)) {
                iprouteMode = true;
            } else if (serviceMode && SERVICE_NAME_TAG.equals(string2)) {
                object3 = (Text)node2.getFirstChild();
                if (object3 != null) {
                    tagPrefix = object3.getData().trim() + ".";
                }
            } else if (SNMP_TAG.equals(string2)) {
                tagPrefix = SNMP_TAG + "@";
            } else if (WS_OBJECT_TAG.equals(string2)) {
                serviceMode = false;
                tagPrefix = null;
                shortcodeMode = false;
                iprouteMode = false;
            }
            if (propertiesSupported && string == null) {
                object3 = new StringBuffer();
                if (tagPrefix != null) {
                    ((StringBuffer)object3).append(tagPrefix);
                }
                ((StringBuffer)object3).append(string2);
                string = sSLVPNProps.getValue(((StringBuffer)object3).toString());
                if (MANDATORY_SERVICE_ACCT_NAME.equals(string2)) {
                    string = sslvpnOnboarding.encryptRSA(publicKey, string);
                } else if (MANDATORY_SERVICE_ACCT_PASSWORD.equals(string2)) {
                    if (string == null) {
                        throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "blank password");
                    }
                    string = sslvpnOnboarding.encryptRSA(publicKey, string);
                    if (passwordHash == null) {
                        passwordHash = string.getBytes(CHARSET);
                    }
                } else if (bl && OPTIONAL_SERVER_ADDRESS.equals(string2) && string == null && ((object2 = (Text)node2.getFirstChild()) == null || object2.getData().trim().isEmpty())) {
                    throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "blank ServerAddress in the properties file or in the xml template");
                }
                if (string == null) {
                    if (shortcodeMode && SHORTCODE_TEL_NUMBER_TAG.equals(string2)) {
                        object2 = null;
                        object = (Text)node2.getFirstChild();
                        if (object != null && (object2 = object.getData().trim()) != null && ((String)object2).length() > 2) {
                            n = ((String)object2).lastIndexOf(34);
                            if (((String)object2).charAt(0) == '\"' && n > 0 && n < ((String)object2).length()) {
                                String string3;
                                String string4 = null;
                                string4 = ((String)object2).substring(1, n);
                                if (string4 != null && sSLVPNProps.getValue(string3 = string4.trim() + "." + SERVICE_NAME_TAG) != null) {
                                    string = "\"" + sSLVPNProps.getValue(string3) + "\"";
                                }
                            }
                        }
                    } else if (iprouteMode && IPROUTE_DESTINATION_TAG.equals(string2)) {
                        object2 = null;
                        object = (Text)node2.getFirstChild();
                        if (object != null && (object2 = object.getData().trim() + "." + SERVICE_NAME_TAG) != null) {
                            string = sSLVPNProps.getValue((String)object2);
                        }
                    }
                }
            }
            if (string != null) {
                object3 = (Text)node2.getFirstChild();
                if (object3 != null) {
                    object3.setData(string);
                } else {
                    ((Element)node2).appendChild(node.getOwnerDocument().createTextNode(string));
                }
            } else {
                object3 = (Text)node2.getFirstChild();
                if (object3 != null) {
                    object2 = object3.getData();
                    if (((String)object2).indexOf(124) != -1) {
                        object = new StringBuffer();
                        for (n = 0; n < ((String)object2).length(); ++n) {
                            char c = ((String)object2).charAt(n);
                            if (Character.isWhitespace(c)) continue;
                            ((StringBuffer)object).append(c);
                        }
                        object3.setData(((StringBuffer)object).toString());
                    } else {
                        object = ((String)object2).trim();
                        if (((String)object).isEmpty() && !((String)object2).startsWith("\n")) {
                            throw new sslvpnException(SSLVPN_RESULT.INVALID_XML_FILE, string2 + " has empty value");
                        }
                        if (((String)object).length() != ((String)object2).length() && !((String)object2).startsWith("\n")) {
                            object3.setData((String)object);
                        }
                    }
                } else {
                    throw new sslvpnException(SSLVPN_RESULT.INVALID_XML_FILE, string2 + " has empty value");
                }
            }
            if (!node2.hasChildNodes()) continue;
            sslvpnOnboarding.updatedoc(publicKey, node2, sSLVPNProps, bl);
        }
    }

    public static void generateSSLVPN(PublicKey publicKey, String string, String string2, String string3, boolean bl) throws sslvpnException, Exception {
        Object object;
        File file = null;
        PrintWriter printWriter = null;
        passwordHash = null;
        if (string == null) {
            throw new sslvpnException(SSLVPN_RESULT.TEMPLATE_FILE_REQUIRED, "Template file name missing");
        }
        if (string2 == null) {
            throw new sslvpnException(SSLVPN_RESULT.OUTPUT_FILE_REQUIRED, "Output file name missing");
        }
        propertiesSupported = string3 != null;
        SSLVPNProps sSLVPNProps = new SSLVPNProps();
        if (propertiesSupported) {
            sSLVPNProps.load(string3);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(string);
        }
        catch (Exception exception) {
            throw new sslvpnException(SSLVPN_RESULT.UNABLE_TO_OPEN_XML_FILE, exception.getMessage());
        }
        object = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = ((SchemaFactory)object).newSchema(ClassLoader.getSystemResource("xsd/sslvpntemplate.xsd"));
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(document));
        }
        catch (Exception exception) {
            throw new sslvpnException(SSLVPN_RESULT.INVALID_XML_FILE, exception.getMessage());
        }
        Element element = document.getDocumentElement();
        if (propertiesSupported) {
            sslvpnOnboarding.validateProperties(sSLVPNProps, element);
        } else {
            sslvpnOnboarding.validateXML(element);
        }
        sslvpnOnboarding.updatedoc(publicKey, document, sSLVPNProps, bl);
        try {
            file = new File(string2);
            printWriter = new PrintWriter(file, CHARSET);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            StringBuilder stringBuilder = new StringBuilder(stringWriter.toString());
            int n = stringBuilder.indexOf("?>");
            if (n == -1) {
                throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "Output file format error");
            }
            stringBuilder.insert(n + 2, "\r\n");
            if (!noSign) {
                String string4 = sslvpnOnboarding.calculateHash(stringBuilder.toString());
                String string5 = sslvpnOnboarding.encryptRSA(publicKey, string4);
                printWriter.write("<DigitalSignature>");
                printWriter.write(string5);
                printWriter.write("</DigitalSignature>\r\n");
            } else {
                printWriter.write("<DigitalSignature></DigitalSignature>\r\n");
            }
            printWriter.write(stringBuilder.toString());
        }
        catch (Exception exception) {
            throw new sslvpnException(SSLVPN_RESULT.UNABLE_TO_OPEN_OUTPUT_FILE, exception.getMessage());
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                throw new sslvpnException(SSLVPN_RESULT.UNABLE_TO_OPEN_OUTPUT_FILE, exception.getMessage());
            }
        }
    }

    private static String calculateHash(String string) throws sslvpnException, UnsupportedEncodingException {
        if (passwordHash == null) {
            passwordHash = "NoService".getBytes(CHARSET);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(passwordHash, "HmacSHA256");
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            byte[] byArray = string.getBytes(CHARSET);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 13 || byArray[i] == 10) continue;
                mac.update(byArray[i]);
            }
            byte[] byArray2 = mac.doFinal();
            return Base64Utils.encodeToString(byArray2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "Unable to calculate signature(state)");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "Unable to calculate signature(key)");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new sslvpnException(SSLVPN_RESULT.INTERNAL_ERROR, "Unable to calculate signature(algorithm)");
        }
    }

    private static void validateXML(Element element) throws sslvpnException {
        NodeList nodeList = element.getElementsByTagName(MANDATORY_SOLDTO);
        if (nodeList.getLength() == 1) {
            Element element2 = (Element)nodeList.item(0);
            Node node = element2.getFirstChild();
            if (node == null) {
                throw new sslvpnException(SSLVPN_RESULT.INVALID_XML_FILE, "Template missing soldto value.");
            }
            if (!sslvpnOnboarding.validateSoldto(((Text)node).getData().trim())) {
                throw new sslvpnException(SSLVPN_RESULT.INVALID_XML_FILE, "Template soldto must be numeric and a maximum of 10 characters.");
            }
        }
    }

    private static boolean validateSoldto(String string) throws sslvpnException {
        int n = string.length();
        if (n == 0 || n > 10) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void validateProperties(SSLVPNProps sSLVPNProps, Element element) throws sslvpnException {
        if (sSLVPNProps.getValue(MANDATORY_SOLDTO) == null) {
            throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE_MANDITORY_FIELD_MISSING, "Property file missing soldto.");
        }
        if (!sslvpnOnboarding.validateSoldto(sSLVPNProps.getValue(MANDATORY_SOLDTO))) {
            throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE, "Template soldto must be numeric and a maximum of 10 characters.");
        }
        String string = sSLVPNProps.getValue(OPTIONAL_SNMP_DEVICEID);
        if (string != null && string.length() > OPTIONAL_SNMP_DEVICEID_LEN) {
            throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE, "Property file SNMP DeviceID length > " + Integer.toString(OPTIONAL_SNMP_DEVICEID_LEN) + ".");
        }
        NodeList nodeList = element.getElementsByTagName(SERVICE_TAG);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Node node2 = node.getFirstChild().getNextSibling();
            String string3 = ((Text)node2.getFirstChild()).getData().trim();
            if (!sSLVPNProps.serviceExists(string3)) {
                throw new sslvpnException(SSLVPN_RESULT.INVALID_XML_FILE_SERVICE_MISSING, "Template service " + string3 + " not found in properties file");
            }
            String string4 = sSLVPNProps.getValue(string3 + "." + MANDATORY_SERVICE_ACCT_NAME);
            if (string4 == null || string4.length() > MANDATORY_SERVICE_ACCT_NAME_LEN) {
                throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE_MANDITORY_FIELD_MISSING, "Property file missing Service " + string3 + " account name or length > " + Integer.toString(MANDATORY_SERVICE_ACCT_NAME_LEN) + ".");
            }
            String string5 = sSLVPNProps.getValue(string3 + "." + MANDATORY_SERVICE_ACCT_PASSWORD);
            if (string5 == null || string5.length() > MANDATORY_SERVICE_ACCT_PASSWORD_LEN) {
                throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE_MANDITORY_FIELD_MISSING, "Property file missing Service " + string3 + " password or length > " + Integer.toString(MANDATORY_SERVICE_ACCT_PASSWORD_LEN) + ".");
            }
            String string6 = sSLVPNProps.getValue(string3 + "." + OPTIONAL_SERVER_ADDRESS);
            if (string6 != null) {
                if (string6.length() > OPTIONAL_SERVER_ADDRESS_LEN) {
                    throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE, "Property file Service Server Address " + string6 + "  length > " + Integer.toString(OPTIONAL_SERVER_ADDRESS_LEN) + ".");
                }
                if (string6.isEmpty()) {
                    throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE, "Property file Service Server Address cannot be blank.");
                }
            }
            if (!((string2 = sSLVPNProps.getValue(string3 + "." + OPTIONAL_SESSION_MODE)) == null || "always_on".equals(string2) || "event_based".equals(string2) || "periodic".equals(string2))) {
                throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE, "Property file Service Session Mode " + string2 + "  invalid value.");
            }
            String string7 = sSLVPNProps.getValue(string3 + "." + OPTIONAL_INFALLBBACK);
            if (string7 == null || "true".equals(string7) || "false".equals(string7)) continue;
            throw new sslvpnException(SSLVPN_RESULT.INVALID_PROP_FILE, "Property file Service InFallBack " + string2 + "  invalid value.");
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = stringArray.length;
        if (n == 0) {
            sslvpnOnboarding.printUsage();
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (PROP_FILE_ID.equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= n) continue;
                string = stringArray[++i];
                continue;
            }
            if (TEMPLATE_FILE_ID.equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= n) continue;
                string2 = stringArray[++i];
                continue;
            }
            if (INVENTORY_FILE_ID.equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= n) continue;
                string4 = stringArray[++i];
                continue;
            }
            if (KEY_FILE_ID.equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= n) continue;
                string5 = stringArray[++i];
                continue;
            }
            if (OUTPUT_FILE_ID.equalsIgnoreCase(stringArray[i])) {
                if (i + 1 >= n) continue;
                string3 = stringArray[++i];
                continue;
            }
            if (NO_SIGN_ID.equalsIgnoreCase(stringArray[i])) {
                noSign = true;
                continue;
            }
            if (!"-help".equalsIgnoreCase(stringArray[i])) continue;
            sslvpnOnboarding.printUsage();
            return;
        }
        try {
            if (string4 == null && string5 == null) {
                System.out.println("Please specify either a Key File or an Inventory File containing IPO's public KEY.");
                System.out.println(SSLVPN_RESULT.KEY_FILE_REQUIRED);
                sslvpnOnboarding.printUsage();
            } else if (string4 != null && string5 != null) {
                System.out.println("Please specify either a Key File or an Inventory File containing IPO's public KEY, not both!");
                System.out.println(SSLVPN_RESULT.KEY_FILE_REQUIRED);
                sslvpnOnboarding.printUsage();
            } else {
                PublicKey publicKey = sslvpnOnboarding.initPubKey(string4, string5);
                if (publicKey != null) {
                    sslvpnOnboarding.generateSSLVPN(publicKey, string2, string3, string, false);
                    System.out.println(SSLVPN_RESULT.SUCCESS);
                } else {
                    System.out.println("The public key could not be parsed.");
                    System.out.println(SSLVPN_RESULT.KEY_FILE_REQUIRED);
                    sslvpnOnboarding.printUsage();
                }
            }
        }
        catch (sslvpnException sslvpnException2) {
            System.out.println(sslvpnException2.getMessage());
            System.out.println(sslvpnException2.getError());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(SSLVPN_RESULT.INTERNAL_ERROR);
        }
    }

    private static void printUsage() {
        System.out.println("sslvpnOnboarding - 9.1.0.0 build 435");
        System.out.println("Generates an SSLVPN OnBoarding XML file for IPOFFICE.\r\n");
        System.out.println("Usage:");
        System.out.println("- sslvpnOnboarding -t <template file> -i <inventory file> -o <output file> [-p <properties file> ]");
        System.out.println("  Example: sslvpnOnboarding -t sslvpn_template.xml -i inventory.xml -o onboarding_file.xml  -p sslvpn.properties\r\n");
        System.out.println("- sslvpnOnboarding -t <template file> -k <key file> -o <output file> [-p <properties file> ]");
        System.out.println("  Example: sslvpnOnboarding -t sslvpn_template.xml -k key.pem -o onboarding_file.xml -p sslvpn.properties");
    }
}

