/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sslvpn;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class WebServiceApiAdapter {
    private static final String CHARSET = "UTF-8";
    private final String SEPARATOR_PATTERN = "<TO>";
    private final String HOST_PATTERN = "<HOST>";
    private final String PARAM_PATTERN = "<?>";
    private final String boundary = "abcde12345";
    private String method;
    private String uri;
    private String userName;
    private String password;
    static final TrustManager[] trustAllCerts;
    static final HostnameVerifier hv;
    private static final char[] chrMap;

    public WebServiceApiAdapter(String string, String string2) throws Exception {
        this.userName = string;
        this.password = string2;
        this.byPassSSLSecurity();
    }

    public void reset() {
        this.method = null;
        this.uri = null;
    }

    public String invokeAction(String string, String string2) throws Exception {
        return this.invokeAction(string, string2, (String)null, (File)null, new String[0]);
    }

    public String invokeAction(String string, String string2, String string3) throws Exception {
        return this.invokeAction(string, string2, string3, null, new String[0]);
    }

    public String invokeAction(String string, String string2, File file, String ... stringArray) throws Exception {
        return this.invokeAction(string, string2, null, file, stringArray);
    }

    public String invokeAction(String string, String string2, String string3, File file, String ... stringArray) throws Exception {
        String string4 = null;
        if (string != null && string2 != null) {
            this.readURIandMethod(string);
            String string5 = null;
            if (this.method != null && this.uri != null) {
                if (this.uri.indexOf("<?>") < 0) {
                    string5 = this.modifyUri(this.uri, string2, new String[0]);
                } else if (stringArray != null && stringArray.length != 0) {
                    string5 = this.modifyUri(this.uri, string2, stringArray);
                } else {
                    throw new Exception("No parameter specified");
                }
                string4 = this.invokeWebService(this.method, string5, file, string3);
            } else {
                throw new Exception("Bad action or not specified");
            }
        }
        return string4;
    }

    private void readURIandMethod(String string) throws Exception {
        if (string != null && string.trim().length() > 0) {
            string = string.trim();
            String[] stringArray = string.split("<TO>");
            this.method = stringArray[0];
            this.uri = stringArray[1];
        }
    }

    private String modifyUri(String string, String string2, String ... stringArray) throws Exception {
        String string3 = null;
        if (string != null && string2 != null) {
            string3 = string.replace("<HOST>", string2);
            if (string.indexOf("<?>") >= 0 && stringArray != null && stringArray.length != 0) {
                if (stringArray.length == 1) {
                    string3 = string3.replace("<?>", URLEncoder.encode(stringArray[0], CHARSET));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (String string4 : stringArray) {
                        stringBuffer.append(string4).append(":");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    string3 = string.replace("<?>", URLEncoder.encode(stringBuffer.toString(), CHARSET));
                }
            }
        } else {
            throw new Exception("IP is required");
        }
        return string3;
    }

    private void byPassSSLSecurity() throws Exception {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            System.setProperty("http.keepAlive", "false");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new Exception("Error byPassSSLSecurity:" + exception.getMessage());
        }
    }

    private void setCommonRequestHeaders(HttpURLConnection httpURLConnection) throws UnsupportedEncodingException {
        if (httpURLConnection != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + WebServiceApiAdapter.encodeString((this.userName + ":" + this.password).getBytes(CHARSET), 0, (this.userName + ":" + this.password).getBytes(CHARSET).length));
            httpURLConnection.setRequestProperty("User-Agent", "Avaya-WebAdmin Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
            httpURLConnection.setRequestProperty("Accept-Charset", CHARSET);
            httpURLConnection.setRequestProperty("Accept", "text/plain, text/xml, text/html, image/gif, image/jpeg");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setAllowUserInteraction(false);
        }
    }

    private void setRequestIO4PostAndPut(HttpURLConnection httpURLConnection) {
        if (httpURLConnection != null) {
            httpURLConnection.setDoOutput(true);
        }
    }

    private void setRequestHeaders4FileTransfer(HttpURLConnection httpURLConnection, File file) {
        if (httpURLConnection != null && file != null) {
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=abcde12345");
            httpURLConnection.setRequestProperty("Content-Length", "" + Long.toString((long)(79 + file.getName().length() + 24) + file.length() + 18L));
        }
    }

    private void setRequestHeaders4XmlPayload(HttpURLConnection httpURLConnection, String string) {
        if (httpURLConnection != null && string != null) {
            httpURLConnection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            httpURLConnection.setRequestProperty("Content-Length", string.length() + "");
        }
    }

    private void setContetType4GetAndDelete(HttpURLConnection httpURLConnection) {
        if (httpURLConnection != null) {
            httpURLConnection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            httpURLConnection.setRequestProperty("Content-Length", "0");
        }
    }

    private void flushFile(HttpURLConnection httpURLConnection, File file) throws Exception {
        if (httpURLConnection != null && file != null) {
            httpURLConnection.connect();
            OutputStream outputStream = httpURLConnection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            BufferedInputStream bufferedInputStream = null;
            try {
                dataOutputStream.writeBytes("--abcde12345\r\n");
                dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"binaryFile\"; filename=\"" + file.getName() + "\"" + "\r\n");
                dataOutputStream.writeBytes("Content-Type: binary\r\n");
                dataOutputStream.writeBytes("\r\n");
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] byArray = new byte[1024];
                int n = 0;
                int n2 = 0;
                while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                    dataOutputStream.write(byArray, 0, n2);
                    n += n2;
                }
                dataOutputStream.writeBytes("\r\n");
                dataOutputStream.writeBytes("--abcde12345--\r\n");
                dataOutputStream.flush();
            }
            catch (Exception exception) {
                throw new Exception(exception.getMessage());
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            dataOutputStream.close();
            outputStream.close();
        }
    }

    private void flushXmlPayload(HttpURLConnection httpURLConnection, String string) throws Exception {
        if (httpURLConnection != null && string != null) {
            OutputStream outputStream = httpURLConnection.getOutputStream();
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, CHARSET), true);
            printWriter.println(string);
            outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileResponse(HttpURLConnection httpURLConnection, File file) throws Exception {
        if (httpURLConnection != null && httpURLConnection.getResponseCode() == 200) {
            if (file != null) {
                FilterOutputStream filterOutputStream = null;
                try {
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                    ((BufferedOutputStream)filterOutputStream).flush();
                }
                finally {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
            }
        } else {
            if (httpURLConnection != null) {
                throw new Exception(httpURLConnection.getResponseCode() + ":" + httpURLConnection.getResponseMessage());
            }
            throw new Exception("Invalid connection reference in readFileResponse");
        }
    }

    private void readXmlResponse(HttpURLConnection httpURLConnection, StringBuffer stringBuffer) throws Exception {
        block6: {
            try {
                if (httpURLConnection == null) {
                    throw new Exception("Invalid connection instance in readXmlResponse");
                }
                if (stringBuffer == null) {
                    throw new Exception("Invalid xmlResponse instance in readXmlResponse");
                }
                if (httpURLConnection.getResponseCode() == 200 || httpURLConnection.getResponseCode() == 202) {
                    char[] cArray = new char[1024];
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF8"));
                    int n = 0;
                    while ((n = bufferedReader.read(cArray)) != -1) {
                        stringBuffer.append(new String(cArray, 0, n));
                    }
                    break block6;
                }
                throw new Exception(httpURLConnection.getResponseCode() + ":" + httpURLConnection.getResponseMessage());
            }
            catch (Exception exception) {
                throw new Exception(exception.getMessage());
            }
        }
    }

    private String invokeWebService(String string, String string2, File file, String string3) throws Exception {
        if (string == null || string2 == null) {
            throw new Exception("Insufficient parameters");
        }
        URL uRL = new URL(string2);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(180000);
        httpURLConnection.setReadTimeout(210000);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.setCommonRequestHeaders(httpURLConnection);
            httpURLConnection.setRequestMethod(string);
            if ("POST".equals(string) || "PUT".equals(string)) {
                this.setRequestIO4PostAndPut(httpURLConnection);
                if (file != null) {
                    this.setRequestHeaders4FileTransfer(httpURLConnection, file);
                    this.flushFile(httpURLConnection, file);
                } else if (string3 != null) {
                    this.setRequestHeaders4XmlPayload(httpURLConnection, string3);
                    this.flushXmlPayload(httpURLConnection, string3);
                } else {
                    this.setContetType4GetAndDelete(httpURLConnection);
                    httpURLConnection.connect();
                }
                this.readXmlResponse(httpURLConnection, stringBuffer);
            } else if ("GET".equals(string) || "DELETE".equals(string)) {
                this.setContetType4GetAndDelete(httpURLConnection);
                httpURLConnection.connect();
                if (file != null) {
                    if ("GET".equals(string)) {
                        this.readFileResponse(httpURLConnection, file);
                        stringBuffer.append("File Returned");
                    }
                } else {
                    this.readXmlResponse(httpURLConnection, stringBuffer);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        finally {
            httpURLConnection.disconnect();
        }
        return stringBuffer.toString();
    }

    private static String encodeString(byte[] byArray, int n, int n2) {
        int n3 = (n2 * 4 + 2) / 3;
        int n4 = (n2 + 2) / 3 * 4;
        char[] cArray = new char[n4];
        int n5 = n;
        int n6 = n + n2;
        int n7 = 0;
        while (n5 < n6) {
            int n8 = byArray[n5++] & 0xFF;
            int n9 = n5 < n6 ? byArray[n5++] & 0xFF : 0;
            int n10 = n5 < n6 ? byArray[n5++] & 0xFF : 0;
            int n11 = n8 >>> 2;
            int n12 = (n8 & 3) << 4 | n9 >>> 4;
            int n13 = (n9 & 0xF) << 2 | n10 >>> 6;
            int n14 = n10 & 0x3F;
            cArray[n7++] = chrMap[n11];
            cArray[n7++] = chrMap[n12];
            cArray[n7] = n7 < n3 ? chrMap[n13] : 61;
            int n15 = ++n7 < n3 ? chrMap[n14] : 61;
            cArray[n7] = n15;
            ++n7;
        }
        return new String(cArray);
    }

    static {
        int n;
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        hv = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        chrMap = new char[64];
        int n2 = 0;
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            WebServiceApiAdapter.chrMap[n2++] = n;
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            WebServiceApiAdapter.chrMap[n2++] = n;
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            WebServiceApiAdapter.chrMap[n2++] = n;
        }
        WebServiceApiAdapter.chrMap[n2++] = 43;
        WebServiceApiAdapter.chrMap[n2++] = 47;
    }

    static class AbgEmAuthenticator
    extends Authenticator {
        String kuser = "Administrator";
        String kpass = "Administrator";

        public AbgEmAuthenticator(String string, String string2) {
            this.kuser = string;
            this.kpass = string2;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.kuser, this.kpass.toCharArray());
        }
    }

    public static class AbgEmHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }
}

