YUI.add("yuidoc-meta", function(Y) {
   Y.YUIDoc = { meta: {
    "classes": [
        "AWL.client"
    ],
    "modules": [
        "Avaya IP Office WebRTC SDK"
    ],
    "allModules": [
        {
            "displayName": "Avaya IP Office WebRTC SDK",
            "name": "Avaya IP Office WebRTC SDK",
            "description": "This document describes about the Avaya IP Office WebRTC SDK Open APIs provided for web client application integration using java script language and these APIs can be used to develop or integrate web pages for consuming the telephony features provided by Avaya IP Office.\n\nThis is a java script based minified SDK(\"awl.min.js\") which takes care of WebRTC functionalities for different WebRTC enabled browsers(latest versions of Chrome and Firefox) as well handles signaling between the WebRTC Gateway(i.e., Signal Gateway) and the web browser client using a secure web socket connection.\n\nThe SDK provides a {{#crossLink \"AWL.client\"}}{{/crossLink}} API interface, which upon instantiation can be used to invoke the following APIs(non-telephony and telephony) listed below inorder to consume the telephony features provided by Avaya IP Office. The details about these APIs and the parameters passed in them are best described in {{#crossLink \"AWL.client\"}}{{/crossLink}}\n\n__Non Telephony APIs:__\n\n       1. {{#crossLink \"AWL.client/isWebRTCSupported:method\"}}{{/crossLink}}()\n       2. {{#crossLink \"AWL.client/getSdkVersion:method\"}}{{/crossLink}}()\n       3. {{#crossLink \"AWL.client/setConfiguration:method\"}}{{/crossLink}}(arg1, callback_onConfigChanged, callback_onRegistrationStateChanged, callback_onCallStateChanged, callback_onAuthTokenRenewed) - Mandatory to call this API, before using {{#crossLink \"AWL.client/logIn:method\"}}{{/crossLink}}(arg1, arg2) API\n       4. {{#crossLink \"AWL.client/enableLogging:method\"}}{{/crossLink}}()\n       5. {{#crossLink \"AWL.client/setDomElements:method\"}}{{/crossLink}}(arg1)\n       6. {{#crossLink \"AWL.client/logIn:method\"}}{{/crossLink}}(arg1, arg2) - Mandatory to call this API, before using any of the Telephony APIs.\n       7. {{#crossLink \"AWL.client/logOut:method\"}}{{/crossLink}}()\n       8. {{#crossLink \"AWL.client/isloggedIn:method\"}}{{/crossLink}}()\n       9. {{#crossLink \"AWL.client/setLogObject:method\"}}{{/crossLink}}(arg1)\n       10. {{#crossLink \"AWL.client/disableLogging:method\"}}{{/crossLink}}()\n       11. {{#crossLink \"AWL.client/getDeviceList:method\"}}{{/crossLink}}(arg1)\n       12. {{#crossLink \"AWL.client/setDeviceIds:method\"}}{{/crossLink}}(arg1)\n       13. {{#crossLink \"AWL.client/playVideo:method\"}}{{/crossLink}}(arg1)\n       14. {{#crossLink \"AWL.client/pauseVideo:method\"}}{{/crossLink}}(arg1)\n       15. {{#crossLink \"AWL.client/getAlternateServerConfig:method\"}}{{/crossLink}}()\n       16. {{#crossLink \"AWL.client/tokenLogIn:method\"}}{{/crossLink}}(arg1, arg2, arg3)\n       17. {{#crossLink \"AWL.client/generateAppInstanceID:method\"}}{{/crossLink}}()\n       18. {{#crossLink \"AWL.client/getStunConfiguration:method\"}}{{/crossLink}}()\n       19. {{#crossLink \"AWL.client/setStunConfiguration:method\"}}{{/crossLink}}(arg1)\n       \n__Telephony APIs:__     \n\n       1.  {{#crossLink \"AWL.client/makeCall:method\"}}{{/crossLink}}(arg1, arg2)\n       2.  {{#crossLink \"AWL.client/answerCall:method\"}}{{/crossLink}}(arg1)\n       3.  {{#crossLink \"AWL.client/rejectCall:method\"}}{{/crossLink}}(arg1)\n       4.  {{#crossLink \"AWL.client/dropCall:method\"}}{{/crossLink}}(arg1)\n       5.  {{#crossLink \"AWL.client/cancelCall:method\"}}{{/crossLink}}(arg1)\n       6.  {{#crossLink \"AWL.client/doHold:method\"}}{{/crossLink}}(arg1)\n       7.  {{#crossLink \"AWL.client/doUnHold:method\"}}{{/crossLink}}(arg1)\n       8.  {{#crossLink \"AWL.client/doMute:method\"}}{{/crossLink}}(arg1)\n       9.  {{#crossLink \"AWL.client/doUnMute:method\"}}{{/crossLink}}(arg1)\n       10. {{#crossLink \"AWL.client/sendDTMF:method\"}}{{/crossLink}}(arg1, arg2)\n       11. {{#crossLink \"AWL.client/transferCall:method\"}}{{/crossLink}}(arg1, arg2 ,arg3)\n       12. {{#crossLink \"AWL.client/getStats:method\"}}{{/crossLink}}(arg1)\n       13. {{#crossLink \"AWL.client/addVideo:method\"}}{{/crossLink}}(arg1)\n       14. {{#crossLink \"AWL.client/removeVideo:method\"}}{{/crossLink}}(arg1)\n       15. {{#crossLink \"AWL.client/setMediaStream:method\"}}{{/crossLink}}(arg1, arg2, arg3, arg4)        \n\n__Network Test APIs:__ \n\n       1.  {{#crossLink \"AWL.client/createLoopBackConnection:method\"}}{{/crossLink}}()\n       2.  {{#crossLink \"AWL.client/endLoopBackConnection:method\"}}{{/crossLink}}()\n       3.  {{#crossLink \"AWL.client/getLoopBackStats:method\"}}{{/crossLink}}()                             \n       \n\n__Pre-requisites:__\n+ WebRTC is available with IP Office Server Edition, IP Office Select and IP Office preferred Edition and to access WebRTC, the associated users must have Power User or Office Worker profiles.\n+ The WebRTC Gateway IP address should be reachable from the web application which is integrated with the SDK.\n\n__Guidelines for using the SDK APIs:__\nIn order to experience Avaya IP Office WebRTC audio/video calls, following mandatory guidelines have to be met first, before using any\nother non Telephony or Telephony APIs.\n\n__Mandatory steps__\n1. Include Avaya IP Office WebRTC SDK file “awl.min.js” in the javascript include list\n2. Create a {{#crossLink \"AWL.client\"}}{{/crossLink}} instance as this would be used to access all the non-telephony and telephony SDK APIs further\n\n       Example: \n               var myWebRTC = new {{#crossLink \"AWL.client\"}}{{/crossLink}}();\n\n3. Set all the configuration (i.e., Populate serviceType(\"phone\" or \"agent\"), enableVideo, Gateway IP address(Mandatory), Stun/Turn(Optional) server details, application data and disableResiliency details as in the following object literal notation template('cfg')) element(arg1)\nalong with the four callback functions arg2, arg3, arg4 and arg5 which would be triggered upon any configuration changes, registration/unregistration state\nchanges, callstate changes and token renewal (if resiliency is not disabled) respectively. All these except arg5 are mandatory arguments to be passed while invoking setConfiguration API. Out of all these fields in arg1 template, mandatory data to be filled is\nGateway IP address or FQDN inorder to setup communication with the Avaya IP Office WebRTC Gateway(i.e., Signal Gateway component).\n\nFor the serviceType property, if set as Phone service(i.e., \"phone\") it provides client to be used as Avaya IP Office extension, with its own UI whereas if set as agentservice(i.e., \"agent\") it is better suited for scenarios where the telephony operations are controlled by CTI application.\nFor the AppData, appInstanceID is the instance Id of the application and should be unique for each instantiation of application or AWL SDK.The appInstanceID can be obtained from AWL SDK utility API  generateAppInstanceID().The appInstanceID is a mandatory configuration and should be done by every AWL SDK based applications.\nThe applicationID and applicationUA are optional configurations to be used by third-party application developers using AWL SDK. The applicationUA represents application name registered with Avaya and applicationID represents the application identity key obtained from Avaya after the application registered with Avaya.\n\n__Note:__\n  1.   Equinox Select Client (or any Client) must set the remembered/persisted appInstanceID again, when AWL SDK is re-instantiated during Fail-over or Fail-back.\n  2.   These two configurations are reserved for future usage.\n\nBy default, resiliency is supported at SDK.To disable resiliency support at SDK,applications have to set the disableResiliency property to true while passing the configuration parameter to setConfiguration API.If disableResiliency is set true,then AWL SDK will not renew the authentication token before it expires.Also,autologin using token during failover and failback will not be supported and the applications have to go for manual login during failover and failback.\n\n   \n       Example: \n               var cfg = {\n                   serviceType: \"phone\",\n                   enableVideo: false,\n                   Gateway: {ip: \"192.0.2.0\", port: \"9443\"},\n                   Stunserver: {ip: \"\", port: \"3478\"},\n                   Turnserver: {ip: \"\", port: \"3478\", user: \"\", pwd: \"\"},\n                   AppData: {applicationID : \"\", applicationUA : \"\", appInstanceID : \"\" },\n                   disableResiliency : false\n               };\n               \n               myWebRTC.{{#crossLink \"AWL.client/setConfiguration:method\"}}{{/crossLink}}(cfg, onConfigChanged, onRegistrationStateChanged, onCallListener, onAuthTokenRenewed);\n                                         \n               //    cfg: arg1\n               //    onConfigChanged: {{#crossLink \"AWL.client/callback_onConfigChanged:event\"}}{{/crossLink}}\n               //    onRegistrationStateChanged: {{#crossLink \"AWL.client/callback_onRegistrationStateChanged:event\"}}{{/crossLink}}\n               //    onCallListener: {{#crossLink \"AWL.client/callback_onCallStateChanged:event\"}}{{/crossLink}}\n               //    onAuthTokenRenewed: {{#crossLink \"AWL.client/callback_onAuthTokenRenewed:event\"}}{{/crossLink}}\n               \n                                                    \n\nThe above API call would invoke the configuration change callback function which was passed as 'callback_onConfigChanged' earlier with the result and reason associated with it.\n4. {{#crossLink \"AWL.client/logIn:method\"}}{{/crossLink}} with the Avaya IP Office SIP username, password as the WebRTC client's username, password in the logIn API.\n\n        Example: \n               myWebRTC.{{#crossLink \"AWL.client/logIn:method\"}}{{/crossLink}}('6501', '********');\n                                |        |\n                                |        |                                 \n                                V        V\n                               arg1     arg2\n\n The above API call would invoke the registration state change callback function which was passed as 'callback_onRegistrationStateChanged' earlier with the result and reason associated with it.\n\n5. Once the login(i.e., Registration) is reported successful, all the telephony APIs can be invoked to make or receive calls and other on call relevant features. During call state changes or for an incoming call 'callback_onCallStateChanged' will get triggered.\n\n6. After successful login, if resiliency support at SDK is not disabled by the client, then the authentication token received from the gateway will be used for autologin to alternate server during failover and tofailback.Also, the authentication token will be renewed by the SDK before it expires.\n\nCopyright (c) 2017 Avaya Inc. All rights reserved."
        }
    ],
    "elements": []
} };
});