package com.avaya.ipoffice.openapi.samples;

import java.io.StringReader;
import java.io.StringWriter;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;


import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import com.avaya.ipoffice.openapi.samples.data.*;
import com.avaya.ipoffice.openapi.samples.data.Error;

public class CallLogSample {

	public LoginSample user1;
	public SendStoredCallLogResponse sendStoredCallLogResponse;
	public String xmlResponse;
	
	public CallLogSample(String username, String password, String serverIP, String port)
	{
		this.user1 = new LoginSample();
		this.user1.login(username, password, serverIP, port);
	}
	
	public static void main(String arg[]) {
	
	}
	
	public Response calllog() {
		String clientSessionId = user1.clientSessionID;
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target("http://"+user1.serverIP+":8080/inyama/service").path("calllog");
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);
		
		try{
			Response response = invocationBuilder.get();
			Source xmlInput = new StreamSource(new StringReader(response.readEntity(String.class)));
	        StringWriter stringWriter = new StringWriter();
	        StreamResult xmlOutput = new StreamResult(stringWriter);
	        TransformerFactory transformerFactory = TransformerFactory.newInstance();
	        transformerFactory.setAttribute("indent-number", 10);
	        Transformer transformer = transformerFactory.newTransformer(); 
	        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	        transformer.transform(xmlInput, xmlOutput);
	        this.xmlResponse = xmlOutput.getWriter().toString();
	        
			invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);
			response = invocationBuilder.get();
			
			if (response.getStatus() == 202) {
				this.sendStoredCallLogResponse = response.readEntity(SendStoredCallLogResponse.class);
			} else {
				Error error = response.readEntity(Error.class);
			}
		
			return response;
		}
		catch(Exception e)
		{
			System.out.println("Exception");
			return null;
		}
	}

}
