
package com.avaya.ipoffice.openapi.samples.data;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for voicemailStates.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="voicemailStates">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="stateNone"/>
 *     &lt;enumeration value="stateNew"/>
 *     &lt;enumeration value="stateUnopenend"/>
 *     &lt;enumeration value="stateOld"/>
 *     &lt;enumeration value="stateSaved"/>
 *     &lt;enumeration value="stateDeleted"/>
 *     &lt;enumeration value="stateTemporary"/>
 *     &lt;enumeration value="stateArchived"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "voicemailStates", namespace = "http://voicemail.common.avaya.com/")
@XmlEnum
public enum VoicemailStates {

    @XmlEnumValue("stateNone")
    STATE_NONE("stateNone"),
    @XmlEnumValue("stateNew")
    STATE_NEW("stateNew"),
    @XmlEnumValue("stateUnopenend")
    STATE_UNOPENEND("stateUnopenend"),
    @XmlEnumValue("stateOld")
    STATE_OLD("stateOld"),
    @XmlEnumValue("stateSaved")
    STATE_SAVED("stateSaved"),
    @XmlEnumValue("stateDeleted")
    STATE_DELETED("stateDeleted"),
    @XmlEnumValue("stateTemporary")
    STATE_TEMPORARY("stateTemporary"),
    @XmlEnumValue("stateArchived")
    STATE_ARCHIVED("stateArchived");
    private final String value;

    VoicemailStates(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static VoicemailStates fromValue(String v) {
        for (VoicemailStates c: VoicemailStates.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }
    
    public static VoicemailStates fromIntValue(int iValue)
    {
    	VoicemailStates returnValue=null;
    	switch(iValue)
    	{
    	case 0:
    		returnValue=STATE_NONE;
    		break;
    	case 1:
    		returnValue=STATE_NEW;
    		break;
    	case 2:
    		returnValue=STATE_UNOPENEND;
    		break;
    	case 3:
    		returnValue=STATE_OLD;
    		break;
    	case 4:
    		returnValue=STATE_SAVED;
    		break;
    	case 5:
    		returnValue=STATE_DELETED;
    		break;
    	default:

    	}
    	return returnValue;
    }
    
    public int intValue()
    {
    	int returnValue=0;
    	switch (this){
    	case STATE_NONE: 
    		returnValue=0;
			break;
    	case STATE_NEW:
    		returnValue=1;
    		break;
    	case STATE_UNOPENEND:
    		returnValue=2;
    		break;
    	case STATE_OLD:
    		returnValue=3;
    		break;
    	case STATE_SAVED:
    		returnValue=4;
    		break;
    	case STATE_DELETED:
    		returnValue=5;
    		break;
    	case STATE_TEMPORARY:
    		returnValue=6;
    		break;
    	case STATE_ARCHIVED:
    		returnValue=7;
    		break;
    	default:
    		
    	}
    	
    	return returnValue;
    	
    }

}
