package com.avaya.ipoffice.openapi.samples.javafx;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.transform.TransformerException;

import com.avaya.ipoffice.openapi.samples.DirectorySample;
import com.avaya.ipoffice.openapi.samples.data.*;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class controllerDirectory {
	
	@FXML TextField usernameTextDirectory;
	@FXML TextField passwordTextDirectory;
	@FXML TextField portTextDirectory;
	@FXML TextField serverTextDirectory;
	@FXML AnchorPane rootDirectory;
	
	@FXML TableView<DirectoryContact> directoryContacts;
	@FXML TableColumn<DirectoryContact, String> directoryContactName;						
	@FXML TableColumn<DirectoryContact, String> directoryContactNumber;
	
	@FXML TextArea xmlResponseDirectory;
	public String name;
	public String password;
	public String serverIP;
	public String port;
	public String clientSessionId = "";
	
	public void mainDirectory()
	{
		ObservableList<DirectoryContact> directoryContactsList = FXCollections.observableArrayList();
		
		this.name = usernameTextDirectory.getText();	
		this.password = passwordTextDirectory.getText();
		this.serverIP = serverTextDirectory.getText();
		this.port = portTextDirectory.getText();
		
		directoryContactName.setCellValueFactory(new PropertyValueFactory<DirectoryContact, String>("firstName"));
		directoryContactNumber.setCellValueFactory(new PropertyValueFactory<DirectoryContact, String>("primaryPhone"));
		DirectorySample dirSample = new DirectorySample(this.name, this.password, this.serverIP, this.port);
		this.clientSessionId = dirSample.user1.clientSessionID;
		
		Response reponse = dirSample.directory();
		DirectorySearchResponse directorySearchResponse = dirSample.directorySearchResponse;
		for(int i=0;i<directorySearchResponse.getList().getContact().size();i++)
		{
			directoryContactsList.add(directorySearchResponse.getList().getContact().get(i));
		}
		directoryContacts.setItems(directoryContactsList);
		xmlResponseDirectory.setWrapText(true);
		xmlResponseDirectory.setStyle("-fx-text-fill: green;");
		xmlResponseDirectory.setText(dirSample.xmlResponse);
	}
	
	public void closeDirectory()
	{
		
		Stage stage = (Stage)rootDirectory.getScene().getWindow();
		
		if(this.clientSessionId.equals(""))
			stage.close();
		else
		{
			Client client = ClientBuilder.newClient();
			WebTarget webTarget = client.target("http://"+serverIP+":"+port+"/inyama/service").path("session");
			Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", this.clientSessionId);
			Response response = invocationBuilder.delete();
			stage.close();
		}
	}
	
}
