﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net;

namespace OneXOpenAPISample
{
    public partial class CallNotification : UserControl
    {
        private CallNotificationData callSessionData;
        private RESTRequest RequestREST = new RESTRequest();
        ServerSettings sampleSettings;

        public CallNotification(CallNotificationData callSessionData, ServerSettings SampleSettings)
        {
            InitializeComponent();
            CallSessionData = callSessionData;
            sampleSettings = SampleSettings;
        }

        public CallNotificationData CallSessionData
        {
            get { return callSessionData; }
            set 
            { 
                callSessionData = value;
                UpdateUI();
            }
        }
        
        private void UpdateUI()
        {
            lblName.Text = callSessionData.Name;
            lblNumber.Text = callSessionData.Number;
            lblStatus.Text = callSessionData.Status.ToString();

            switch (callSessionData.Status)
            {
                case CallNotificationStatus.Ringing:
                    {
                        lblStatus.ForeColor = Color.RoyalBlue;
                        BtnAnswer.Visible = true;
                        BtnEnd.Visible = false;
                        BtnHold.Visible = false;
                        BtnUnHold.Visible = false;
                    }
                    break;
                case CallNotificationStatus.Incoming:
                    {
                        lblStatus.ForeColor = Color.SlateBlue;
                        BtnAnswer.Visible = true;
                        BtnEnd.Visible = false;
                        BtnHold.Visible = false;
                        BtnUnHold.Visible = false;
                    }
                    break;
                case CallNotificationStatus.Alerting:
                    {
                        lblStatus.ForeColor = Color.BlueViolet;
                        BtnAnswer.Visible = false;
                        BtnEnd.Visible = true;
                        BtnHold.Visible = false;
                        BtnUnHold.Visible = false;
                    }
                    break;
                case CallNotificationStatus.Connected:
                    {
                        lblStatus.ForeColor = Color.Green;
                        BtnAnswer.Visible = false;
                        BtnEnd.Visible = true;
                        BtnHold.Visible = true;
                        BtnUnHold.Visible = true;
                    }
                    break;
                case CallNotificationStatus.OnHold:
                    {
                        lblStatus.ForeColor = Color.Orange;
                        BtnAnswer.Visible = false;
                        BtnEnd.Visible = true;
                        BtnHold.Visible = false;
                        BtnUnHold.Visible = true;
                    }
                    break;
                case CallNotificationStatus.Failed:
                    {
                        lblStatus.ForeColor = Color.Red;
                        BtnAnswer.Visible = false;
                        BtnEnd.Visible = true;
                        BtnHold.Visible = false;
                        BtnUnHold.Visible = false;
                    }
                    break;
                default:
                    {
                        lblStatus.ForeColor = Color.Black;
                        BtnAnswer.Visible = true;
                        BtnEnd.Visible = true;
                        BtnHold.Visible = true;
                        BtnUnHold.Visible = true;
                    }
                    break;
            }
        }

        private void BtnAnswer_Click(object sender, EventArgs e)
        {
            try
            {
                ConnectionID cID = new ConnectionID() { Items = new object[] { callSessionData.CallId } };
                AnswerCall obj = new AnswerCall();
                obj.callToBeAnswered = cID;
                Serializer serializer = new Serializer();
                String postData = serializer.Serialize(obj);
                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/callcontrol/answerCall", postData, HTTPMethod.POST, callSessionData.SessionId, out requestStatus);
            }
            catch { }
        }

        private void BtnEnd_Click(object sender, EventArgs e)
        {
            try
            {
                ConnectionID cID = new ConnectionID() { Items = new object[] { callSessionData.CallId } };
                ClearConnection obj = new ClearConnection();
                obj.connectionToBeCleared = cID;
                Serializer serializer = new Serializer();
                String postData = serializer.Serialize(obj);
                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/callcontrol/clearConnection", postData, HTTPMethod.POST, callSessionData.SessionId, out requestStatus);
            }
            catch { }
        }

        private void BtnHold_Click(object sender, EventArgs e)
        {
            try
            {
                ConnectionID cID = new ConnectionID() { Items = new object[] { callSessionData.CallId } };
                HoldCall obj = new HoldCall();
                obj.callToBeHeld = cID;
                Serializer serializer = new Serializer();
                String postData = serializer.Serialize(obj);
                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/callcontrol/holdCall", postData, HTTPMethod.POST, callSessionData.SessionId, out requestStatus);
            }
            catch { }
        }

        private void BtnUnHold_Click(object sender, EventArgs e)
        {
            ConnectionID cID = new ConnectionID() { Items = new object[] { callSessionData.CallId } };
            RetrieveCall obj = new RetrieveCall();
            obj.callToBeRetrieved = cID;
            Serializer serializer = new Serializer();
            String postData = serializer.Serialize(obj);
            HttpStatusCode requestStatus = HttpStatusCode.Continue;
            string response = RequestREST.Send(this.sampleSettings, "/inyama/service/callcontrol/RetrieveCall", postData, HTTPMethod.POST, callSessionData.SessionId, out requestStatus);
        }
    }

    public enum CallNotificationStatus
    {
        Ringing,
        Incoming,
        Alerting,
        Connected,
        OnHold,
        Failed
    }

    public class CallNotificationData
    {
        public string SessionId { get; set; }
        public string CallId { get; set; }
        public string Name { get; set; }
        public string Number { get; set; }
        public CallNotificationStatus Status { get; set; }
    }
}
