﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace OneXOpenAPISample
{
    public partial class CallSnapshot : Form
    {
        private ServerSettings sampleSettings;
        private LoginResponseDetails responseDetails;
        private RESTRequest RequestREST = new RESTRequest();
        private WebSocketService service;

        public CallSnapshot(ServerSettings SampleSettings)
        {
            InitializeComponent();
            this.sampleSettings = SampleSettings;
            txtServer.Text = this.sampleSettings.Server;
            txtPort.Text = this.sampleSettings.Port + " (" + (this.sampleSettings.Secure ? "Secure" : "UnSecure") + ")";
            txtUserId.Text = this.sampleSettings.UserId;
            txtPassword.Text = this.sampleSettings.Password;
            lblWait.Visible = false;
            tlpMakeCall.Visible = false;
        }

        private void BtnCallSnapshot_Click(object sender, EventArgs e)
        {
             lblWait.Visible = true;
             if (Login() == true)
             {
                 service = new WebSocketService(responseDetails.sessionId, true);
                 service.Events.CollectionChanged -= new System.Collections.Specialized.NotifyCollectionChangedEventHandler(Events_CollectionChanged);
                 service.Events.CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(Events_CollectionChanged);
                 bool IsEventDeliveryServiceStarted = service.Start(responseDetails.webSocketWssUrl, string.Empty);
                 if (IsEventDeliveryServiceStarted)
                 {
                     SnapshotDevice obj = new SnapshotDevice();
                     byte[] byteArray = Encoding.UTF8.GetBytes(this.responseDetails.switchDevice);
                     DeviceID callingDev = new DeviceID() { Value = this.responseDetails.userExtension };
                     callingDev.typeOfNumber = typeOfNumberEnum.deviceNumber;
                     callingDev.switchingSubDomainInformationElements = byteArray;
                     MediaClassComponents[] mediaClassArray = new MediaClassComponents[] { MediaClassComponents.voice };
                     callingDev.mediaClass = mediaClassArray;
                     obj.snapshotObject = callingDev;
                     Serializer serializer = new Serializer();
                     String postData = serializer.Serialize(obj);
                     HttpStatusCode requestStatus = HttpStatusCode.Continue;
                     string response = RequestREST.Send(this.sampleSettings, "/inyama/service/snapshot", postData, HTTPMethod.GET, this.responseDetails.sessionId, out requestStatus);
                     if (requestStatus == HttpStatusCode.OK || requestStatus == HttpStatusCode.Accepted)
                     {
                         BtnCallSnapshot.Enabled = false;
                     }
                     else
                     {
                         BtnCallSnapshot.Enabled = true;
                     }
                     lblWait.Text = "Listening To Call Events . . .";
                     lblWait.ForeColor = Color.Green;
                 }
                 tlpMakeCall.Visible = true;
             }
             else
             {
                 lblWait.Visible = false;
             }
        }

        private void Events_CollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            foreach (var _event in e.NewItems)
            {
                Debug.Print(_event.ToString());
                switch (_event.ToString())
                {
                    case "CallInformationEvent":
                        OnCallInformationEvent(_event);
                        break;
                    case "DeliveredEvent":
                        OnCallDeliveredEvent(_event);
                        break;
                    case "EstablishedEvent":
                        OnCallEstablishedEvent(_event);
                        break;
                    case "ConnectionClearedEvent": 
                        OnCallClearedEvent(_event);
                        break;
                    case "HeldEvent":
                        OnCallHeldEvent(_event);
                        break;
                    case "RetrievedEvent":
                        OnCallRetrievedEvent(_event);
                        break;
                    case "FailedEvent":
                        OnCallFailedEvent(_event);
                        break;
                }
            }
        }

        private void OnCallFailedEvent(object _event)
        {
            if (_event != null && _event is FailedEvent)
            {
                FailedEvent evtData = (FailedEvent)_event;
                if (((DeviceID)(((ExtendedDeviceID)(evtData.failingDevice)).Item)).Value != null)
                {
                    try
                    {
                        DeviceID calledDevice = (DeviceID)evtData.calledDevice.Item;
                        DeviceID callingDevice = (DeviceID)evtData.callingDevice.Item;

                        AddUpdateCallNotifications(new CallNotificationData() { Name = calledDevice.Value, Number = calledDevice.Value, Status = CallNotificationStatus.Failed, CallId = evtData.failedConnection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
                    }
                    catch { }
                }
            }
        }

        private void OnCallRetrievedEvent(object _event)
        {
            try
            {
                RetrievedEvent evtData = (RetrievedEvent)_event;
                AddUpdateCallNotifications(new CallNotificationData() { Name = string.Empty, Number = string.Empty, Status = CallNotificationStatus.Connected, CallId = evtData.retrievedConnection.Items[0].ToString(), SessionId = responseDetails.sessionId });
            }
            catch { }
        }

        private void OnCallHeldEvent(object _event)
        {
            try
            {
                HeldEvent evtData = (HeldEvent)_event;
                AddUpdateCallNotifications(new CallNotificationData() { Name = string.Empty, Number = string.Empty, Status = CallNotificationStatus.OnHold, CallId = evtData.heldConnection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
            }
            catch {}
        }

        private void OnCallClearedEvent(object _event)
        {
            string callID = string.Empty;
            ConnectionClearedEvent evtData = (ConnectionClearedEvent)_event;
            if (((DeviceID)evtData.releasingDevice.Item).Value != null)
            {
                callID = evtData.droppedConnection.Items[0].ToString();
            }
            RemoveCallNotification(callID);
        }

        private void OnCallEstablishedEvent(object _event)
        {
            try
            {
                EstablishedEvent evtData = (EstablishedEvent)_event;
                try
                {
                    if (evtData.associatedCalledDevice != null || evtData.associatedCallingDevice != null)
                    {
                        return;
                    }
                }
                catch { }

                DeviceID calledDevice = null;
                DeviceID callingDevice = null;
                if (evtData.calledDevice != null && evtData.callingDevice != null)
                {
                    calledDevice = (DeviceID)evtData.calledDevice.Item;
                    callingDevice = (DeviceID)evtData.callingDevice.Item;
                }

                bool hold = false;
                if (evtData.localConnectionInfo == LocalConnectionState.hold)
                    hold = true;

                string relatedCallId = "";
                if (evtData.establishedConnection != null)
                {
                    if (evtData.callLinkageData != null && evtData.callLinkageData != null && evtData.callLinkageData.globalCallData.globalCallLinkageID != null && evtData.callLinkageData.globalCallData.globalCallLinkageID.Item != null)
                    {
                        relatedCallId = evtData.callLinkageData.globalCallData.globalCallLinkageID.Item;
                    }

                    if (calledDevice != null && callingDevice != null)
                    {
                        if (relatedCallId != evtData.establishedConnection.Items[0].ToString())
                        {
                            AddUpdateCallNotifications(new CallNotificationData() { Name = callingDevice.Value, Number = calledDevice.Value, Status = CallNotificationStatus.Connected, CallId = relatedCallId, SessionId = responseDetails.sessionId });   
                        }
                        else
                        {
                            AddUpdateCallNotifications(new CallNotificationData() { Name = this.ConvertByteArrayToString((byte[])evtData.userData.Item), Number = calledDevice.Value, Status = CallNotificationStatus.Connected, CallId = evtData.establishedConnection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
                        }
                    }
                }
                else
                {
                }
            }
            catch { }
        }

        private void OnCallDeliveredEvent(object _event)
        {
            try
            {
                DeliveredEvent evtData = (DeliveredEvent)_event;
                DeviceID callingDevice = null;
                DeviceID calledDevice = null;
                DeviceID alertingDevice = null;

                if (evtData.calledDevice != null && evtData.callingDevice != null && evtData.alertingDevice != null && evtData.connection != null)
                {
                    callingDevice = (DeviceID)evtData.callingDevice.Item;
                    calledDevice = (DeviceID)evtData.calledDevice.Item;
                    alertingDevice = (DeviceID)evtData.calledDevice.Item;
                    try
                    {
                        if (evtData.associatedCalledDevice != null || evtData.associatedCallingDevice != null)
                        {
                            return;
                        }
                    }
                    catch { }
                    string callerPartyName = "";
                    string calledPartyName = "";
                    try
                    {
                        if (evtData.extensions.privateData != null && evtData.extensions.privateData.@private != null)
                        {
                            Deserilizer deserializer = new Deserilizer();
                            object additionalCallInfo = deserializer.Deserlize(typeof(additionalCallInfo).Name, ((CSTAPrivateDataPrivate)evtData.extensions.privateData.@private).Any[0].InnerXml);
                            if (additionalCallInfo is additionalCallInfo)
                            {
                                callerPartyName = ((additionalCallInfo)additionalCallInfo).callingPartyInfo.callerName;
                                calledPartyName = ((additionalCallInfo)additionalCallInfo).calledPartyInfo.callerName;
                            }
                        }
                    }
                    catch { }

                    if (evtData.localConnectionInfo == LocalConnectionState.alerting)
                    {
                        if (!string.IsNullOrEmpty(callingDevice.Value) && callingDevice.Value == responseDetails.userExtension)
                        {
                            if (evtData.servicesPermitted != null && evtData.servicesPermitted.callControlServices != null && evtData.servicesPermitted.callControlServices.answerCall)
                            {
                                AddUpdateCallNotifications(new CallNotificationData() { Name = callerPartyName, Number = callingDevice.Value, Status = CallNotificationStatus.Incoming, CallId = evtData.connection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
                            }
                            else
                            {
                                AddUpdateCallNotifications(new CallNotificationData() { Name = calledPartyName, Number = calledDevice.Value, Status = CallNotificationStatus.Alerting, CallId = evtData.connection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
                            }
                        }
                        else
                        {
                            AddUpdateCallNotifications(new CallNotificationData() { Name = callerPartyName, Number = callingDevice.Value, Status = CallNotificationStatus.Incoming, CallId = evtData.connection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
                        }
                    }
                    else if (evtData.localConnectionInfo == LocalConnectionState.connected)
                    {
                        AddUpdateCallNotifications(new CallNotificationData() { Name = calledPartyName, Number = calledDevice.Value, Status = CallNotificationStatus.Alerting, CallId = evtData.connection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
                    }
                }
            }
            catch { }
        }

        private void OnCallInformationEvent(object _event)
        {
            string calledPartyName ="";
            string callingPartyName ="";
            CallInformationEvent evtData = (CallInformationEvent)_event;
            try
            {
                if (evtData.extensions.privateData != null && evtData.extensions.privateData.@private != null)
                {
                    object additionalCallInfo = null;
                    for (int i = 0; i < ((CSTAPrivateDataPrivate)evtData.extensions.privateData.@private).Any.Length; i++)
                    {
                        Deserilizer deserializer = new Deserilizer();
                        additionalCallInfo = deserializer.Deserlize(typeof(additionalCallInfo).Name, ((CSTAPrivateDataPrivate)evtData.extensions.privateData.@private).Any[i].InnerXml);
                        if (additionalCallInfo != null)
                            break;
                    }

                    if (additionalCallInfo is additionalCallInfo)
                    {
                        calledPartyName = ((additionalCallInfo)additionalCallInfo).calledPartyInfo.callerName;
                        callingPartyName = ((additionalCallInfo)additionalCallInfo).callingPartyInfo.callerName;
                    }
                    AddUpdateCallNotifications(new CallNotificationData() { Name = calledPartyName, Number = ((DeviceID)evtData.deviceInfo).Value, Status = CallNotificationStatus.Connected, CallId = evtData.connection.Items[0].ToString(), SessionId = responseDetails.sessionId });   
                }
            }
            catch { }
        }

        private void AddUpdateCallNotifications(CallNotificationData callSessionData)
        {
            if (this.flpCallNotifications.InvokeRequired)
            {
                this.flpCallNotifications.BeginInvoke((MethodInvoker)delegate() { AddUpdateCallNotifications(callSessionData); });
            }
            else
            {
                bool found = false;
                foreach (CallNotification callNotification in flpCallNotifications.Controls)
                {
                    if (callNotification.CallSessionData.CallId == callSessionData.CallId)
                    {
                        found = true;
                        CallNotificationData original = callNotification.CallSessionData;
                        original.Status = callSessionData.Status;
                        callNotification.CallSessionData = original;
                        break;
                    }
                }
                if (found == false)
                {
                    flpCallNotifications.Controls.Add(new CallNotification(callSessionData, sampleSettings));
                }
            }
        }

        private void RemoveCallNotification(string callID)
        {
            if (this.flpCallNotifications.InvokeRequired)
            {
                this.flpCallNotifications.BeginInvoke((MethodInvoker)delegate() { RemoveCallNotification(callID); });
            }
            else
            {
                foreach (CallNotification callNotification in flpCallNotifications.Controls)
                {
                    if (callNotification.CallSessionData.CallId == callID)
                    {
                        flpCallNotifications.Controls.Remove(callNotification);
                        break;
                    }
                }
            }
        }

        public string ConvertByteArrayToString(byte[] input)
        {
            System.Text.UTF8Encoding decoder = new System.Text.UTF8Encoding();
            return decoder.GetString(input);
        }

        private bool Login()
        {
            responseDetails = new LoginResponseDetails();

            userLoginRequest obj = new userLoginRequest();
            LoginSubscriptionRequest req = new LoginSubscriptionRequest();
            req.eventTypes = new EventType[] { EventType.CallControlFeaturesEvents, EventType.CallLogEvents, EventType.PhysicalDeviceFeaturesEvents, EventType.DeviceMaintenanceEvents, EventType.VoicemailServicesEvents, EventType.CapabilityExchangeServicesCallbackEvents, EventType.SystemServicesCallbackEvents, EventType.MonitoringServicesCallbackEvents, EventType.IOServicesFeaturesCallbackEvents, EventType.LogicalDeviceFeaturesEvents, EventType.SnapshotServicesCallbackEvents, EventType.CallAssociatedFeaturesEvents, EventType.LogoutEvents, EventType.PresenceEvents, EventType.DirectoryEvents, EventType.RecordingServicesEvents, EventType.ImEvents, EventType.PhotoChangeEvents, EventType.IPOConfigChangeEvents };

            req.httpMethod = HttpMethod.WEBSOCKET;
            req.httpMethodSpecified = true;

            obj.loginSubscriptionRequest = req;
            obj.applicationName = "AvayaIPOfficePlugin";
            obj.userName = this.sampleSettings.UserId;
            obj.userPassword = this.sampleSettings.Password;
            obj.applicationVersion = this.sampleSettings.AppVersion;

            Serializer serializer = new Serializer();

            HttpStatusCode requestStatus = HttpStatusCode.Continue;
            String postData = serializer.Serialize(obj);
            string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session?debug=true", postData, HTTPMethod.POST, "", out requestStatus);
            responseDetails.serverResponse = response;

            if (requestStatus == HttpStatusCode.OK || requestStatus == HttpStatusCode.Accepted)
            {
                XmlDocument doc = new XmlDocument();
                doc.LoadXml(response);
                Deserilizer deserializer = new Deserilizer();
                Object responseObj = deserializer.Deserlize("userLoginResponse", doc.InnerXml);

                if (responseObj != null)
                {
                    userLoginResponse loginResponse = (userLoginResponse)responseObj;
                    if (loginResponse != null)
                    {
                        if (!string.IsNullOrEmpty(loginResponse.clientSessionID))
                        {
                            responseDetails.sessionId = loginResponse.clientSessionID;
                            responseDetails.serverVersion = loginResponse.applicationVersion;
                            responseDetails.loginFailureCode = loginResponse.loginFailureCode;
                            responseDetails.webSocketWssUrl = loginResponse.webSocketWssUrl;
                            responseDetails.webSocketWsUrl = loginResponse.webSocketWsUrl;
                            responseDetails.switchDevice = loginResponse.userSwitchDevice;
                            responseDetails.userExtension = loginResponse.userExtension;
                            responseDetails.isLoggedIn = true;
                        }
                    }
                }
            }

            return responseDetails.isLoggedIn;
        }

        private void BtnMakeCall_Click(object sender, EventArgs e)
        {
            try
            {
                if (!string.IsNullOrEmpty(txtPhoneNumber.Text))
                {
                    MakeCall obj = new MakeCall();
                    DeviceID calledDev = new DeviceID() { Value = txtPhoneNumber.Text };
                    MediaClassComponents[] mediaClassArray = new MediaClassComponents[] { MediaClassComponents.audio };
                    calledDev.mediaClass = mediaClassArray;
                    byte[] byteArray = Encoding.UTF8.GetBytes(this.responseDetails.switchDevice);
                    calledDev.typeOfNumber = typeOfNumberEnum.dialingNumber;
                    obj.calledDirectoryNumber = calledDev;
                    DeviceID callingDev = new DeviceID() { Value = this.responseDetails.userExtension };
                    callingDev.mediaClass = mediaClassArray;
                    callingDev.typeOfNumber = typeOfNumberEnum.dialingNumber;
                    callingDev.switchingSubDomainInformationElements = byteArray;
                    obj.callingDevice = callingDev;  
                    MediaCallCharacteristics mediaCallChar = new MediaCallCharacteristics();
                    mediaCallChar.mediaClass = new MediaClass() { voice = true, voiceSpecified = true };
                    obj.mediaCallCharacteristics = mediaCallChar;
                    obj.autoOriginate = AutoOriginate.doNotPrompt;
                    string callIdentifier = Guid.NewGuid().ToString();
                    CorrelatorData corrData = new CorrelatorData();
                    byte[] byteArrayString = Encoding.UTF8.GetBytes(callIdentifier);
                    corrData.Item = byteArrayString;
                    obj.correlatorData = corrData;
                    obj.subjectOfCall = "Testing";
                    HttpStatusCode requestStatus = HttpStatusCode.Continue;
                    Serializer serializer = new Serializer();
                    String postData = serializer.Serialize(obj);
                    string response = RequestREST.Send(this.sampleSettings, "/inyama/service/callcontrol/makeCall", postData, HTTPMethod.POST, responseDetails.sessionId, out requestStatus);
                    txtPhoneNumber.Text = string.Empty;
                }
            }
            catch { }
        }

        private void Logout()
        {
            if (responseDetails != null && responseDetails.isLoggedIn == true)
            {
                if (service.IsStarted) { service.Stop(); }

                userLoginRequest obj = new userLoginRequest();
                obj.applicationName = "AvayaIPOfficePlugin";
                obj.userName = this.sampleSettings.UserId;
                obj.userPassword = this.sampleSettings.Password;
                Serializer serializer = new Serializer();

                HttpStatusCode requestStatus = HttpStatusCode.Continue;
                String postData = serializer.Serialize(obj);
                string response = RequestREST.Send(this.sampleSettings, "/inyama/service/session", postData, HTTPMethod.DELETE, "", out requestStatus);
                responseDetails.isLoggedIn = false;
            }
        }
        private void BtnClose_Click(object sender, EventArgs e)
        {
            Logout();
            this.Close();
        }

        private class LoginResponseDetails
        {
            public string sessionId { get; set; }
            public string serverVersion { get; set; }
            public userLoginResponseLoginFailureCode loginFailureCode { get; set; }
            public string webSocketWssUrl { get; set; }
            public string webSocketWsUrl { get; set; }
            public string serverResponse { get; set; }
            public bool isLoggedIn { get; set; }
            public string userExtension { get; set; }
            public string switchDevice { get; set; }
        }

        private void CallLogForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Logout();
        }
    }
}
