﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Security;
using System.Net.Sockets;
using System.Security.Authentication;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace OneXOpenAPISample
{
    public partial class Mainform : Form
    {
        public Mainform()
        {
            InitializeComponent();
            System.Net.ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls12 | SecurityProtocolType.Ssl3;
            txtServer.Focus();
            txtServer.SelectionStart = txtServer.Text.Length;
            lblError.Visible = false;
        }

        public ServerSettings SampleSettings 
        {
            get { 
                return new ServerSettings() { Server = txtServer.Text.Trim(), Port = txtPort.Text.Trim(), Secure = chkSecure.Checked, UserId = txtUserId.Text.Trim(), Password = txtPassword.Text.Trim(), AppVersion = txtVersion.Text.Trim()}; 
            } 
        }
        
        private void BtnLogin_Click(object sender, EventArgs e)
        {
            if (InputDataFilled())
            {
                LoginForm Obj = new LoginForm(SampleSettings);
                Obj.ShowDialog();
            }
        }
        
        private void BtnDirectory_Click(object sender, EventArgs e)
        {
            if (InputDataFilled())
            {
                DirectoryForm Obj = new DirectoryForm(SampleSettings);
                Obj.ShowDialog();
            }
        }

        private void BtnCallLogs_Click(object sender, EventArgs e)
        {
            if (InputDataFilled())
            {
                CallLogForm Obj = new CallLogForm(SampleSettings);
                Obj.ShowDialog();
            }
        }

        private void BtnVoicemail_Click(object sender, EventArgs e)
        {
            if (InputDataFilled())
            {
                VoicemailForm Obj = new VoicemailForm(SampleSettings);
                Obj.ShowDialog();
            }
        }

        private void BtnSnapshot_Click(object sender, EventArgs e)
        {
            if (InputDataFilled())
            {
                CallSnapshot Obj = new CallSnapshot(SampleSettings);
                Obj.ShowDialog();
            }
        }

        private void BtnClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void chkSecure_CheckedChanged(object sender, EventArgs e)
        {
            if (chkSecure.CheckState == CheckState.Checked)
            {
                txtPort.Text = "9443";
            }
            else
            {
                txtPort.Text = "8080";
            }
        }

        private bool InputDataFilled()
        {
            if(string.IsNullOrEmpty(txtServer.Text) || string.IsNullOrEmpty(txtPort.Text) || string.IsNullOrEmpty(txtUserId.Text) || string.IsNullOrEmpty(txtPassword.Text) || string.IsNullOrEmpty(txtVersion.Text))
            {
                lblError.Visible = true;
                return false;
                
            }
            lblError.Visible = false;
            return true;
        }
    }

    public class ServerSettings
    {
        public string Server { get; set; }
        public string Port { get; set; }
        public bool Secure { get; set; }
        public string UserId { get; set; }
        public string Password { get; set; }
        public string AppVersion { get; set; }
    }

    public class RESTRequest
    {
        public RESTRequest()
        {
            ServicePointManager.ServerCertificateValidationCallback = new System.Net.Security.RemoteCertificateValidationCallback(Utilities.CertificateValidationCallback);
        }

        public string Send(ServerSettings settings, string uri, string postData, HTTPMethod method, string sessionId, out HttpStatusCode HTTPStatusCode)
        {
            HTTPStatusCode = HttpStatusCode.Continue;
            try
            {
                HttpWebResponse response;
                System.Net.ServicePointManager.Expect100Continue = false;
                String requestUri = "https://" + settings.Server + ":" + settings.Port + uri;
                HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(requestUri);
                WebHeaderCollection header = new WebHeaderCollection();
                header.Add("ClientSessionId", sessionId);
                request.Headers = header;
                request.ProtocolVersion = HttpVersion.Version10;
                request.Method = method.ToString();
                Stream dataStream;

                if (method == HTTPMethod.POST || method == HTTPMethod.PUT || method == HTTPMethod.DELETE)
                {
                    String queryData = postData;
                    byte[] byteArray = Encoding.UTF8.GetBytes(queryData);
                    request.ContentType = "text/xml";
                    request.UserAgent = "AvayaIPOfficePlugin";
                    request.ContentLength = byteArray.Length;
                    dataStream = request.GetRequestStream();
                    dataStream.Write(byteArray, 0, byteArray.Length);
                    dataStream.Close();
                }
                response = (HttpWebResponse)request.GetResponse();
                HTTPStatusCode = ((HttpWebResponse)response).StatusCode;
                dataStream = response.GetResponseStream();

                StreamReader reader = null;
                string responseFromServer = string.Empty;
                if (response.ContentLength <= 0)
                {
                    reader = new StreamReader(dataStream, Encoding.UTF8, false, 368640);
                    responseFromServer = reader.ReadToEnd();
                    reader.Close();
                }
 
                dataStream.Close();
                response.Close();
                return responseFromServer;
            }
            catch (WebException ex)
            {
                string responseFromServer = string.Empty;
                if (ex.Response != null)
                {
                    HTTPStatusCode = ((HttpWebResponse)(ex.Response)).StatusCode;
                    Stream dataStream = ex.Response.GetResponseStream();
                    StreamReader reader = new StreamReader(dataStream, Encoding.UTF8, false, 368640);
                    responseFromServer = reader.ReadToEnd();
                }
                else
                {
                    responseFromServer = ex.Status.ToString();
                }
                return responseFromServer;
            }
            catch (Exception)
            {
                return "";
            }
        }
    }

    public enum HTTPMethod
    {
        GET,
        POST,
        DELETE,
        PUT
    }

    public class Deserilizer
    {
        public Object Deserlize(String eventType, String xmlData)
        {
            try
            {
                TextReader reader = new StringReader(xmlData);
                Type typeOfEvent = Type.GetType(eventType);

                XmlSerializer eventSerializer = new XmlSerializer(typeOfEvent);
                Object evt = (Object)eventSerializer.Deserialize(reader);
                return evt;
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
            return null;
        }
    }

    public class Serializer
    {
        public String Serialize(Object obj)
        {
            XmlSerializer serializer = new XmlSerializer(obj.GetType());
            StringBuilder sb = new StringBuilder();
            TextWriter writer = new StringWriter(sb);
            serializer.Serialize(writer, obj);
            return (sb.ToString());
        }
    }

    public static class Logger 
    {
        internal static void LogInfo(string p1, string p2)
        {
            Debug.Print(p1 + Environment.NewLine + p2);
        }

        internal static void LogWarning(string p1, string p2)
        {
            Debug.Print(p1 + Environment.NewLine + p2);
        }

        internal static void LogError(string p1, string p2, string p3, string p4)
        {
            Debug.Print(p1 + Environment.NewLine + p2 + Environment.NewLine + p3 + Environment.NewLine + p4);
        }

        internal static void LogError(string p1, string p2, string p3)
        {
            Debug.Print(p1 + Environment.NewLine + p2 + Environment.NewLine + p3);
        }
    }
}

