package com.avaya.ipoffice.openapi.samples.adapter.callcontrol;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.adapter.OpenApiRestServiceConfig;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotVoiceMailbox;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ClearConnection;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ConnectionID;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CorrelatorData;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DeviceID;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Error;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Errors;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.MakeCall;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.MediaCallCharacteristics;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.MediaClass;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.MediaClassComponents;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.SnapshotCall;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.SnapshotDevice;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TypeOfNumberEnum;

public class CallControlOpenApiRestAdapter extends OpenApiRestServiceConfig {
	
	public static void getCallSnapshot(String clientSessionId, String subdomain, String extn) throws Exception {
		
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("snapshot");
		
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);
		/*
		SnapshotDevice  snapshotDevice = new SnapshotDevice();
		DeviceID device = new DeviceID();
		device.setValue(extn);
		device.setTypeOfNumber(TypeOfNumberEnum.DEVICE_NUMBER);
		device.setSwitchingSubDomainInformationElements(subdomain.getBytes());
		device.getMediaClass().add(MediaClassComponents.VOICE);
		snapshotDevice.setSnapshotObject(device);
		Entity<SnapshotDevice> entity = Entity.entity(snapshotDevice, MediaType.APPLICATION_XML);
		
		Response response = invocationBuilder.post(entity);
		*/
		Response response = invocationBuilder.get();
		//System.out.println( response.readEntity(String.class));
		if (response.getStatus() != 202) {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}

	public static void makeCall(String clientSessionId, String subdomain, String callingNumber, String calledNumber) throws OpenApiException {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("callcontrol/makeCall");
		
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);

		MakeCall makeCall = new MakeCall();
		DeviceID callingDevice = new DeviceID();
		callingDevice.setValue(callingNumber);
		callingDevice.setTypeOfNumber(TypeOfNumberEnum.DIALING_NUMBER);
		callingDevice.setSwitchingSubDomainInformationElements(subdomain.getBytes());
		DeviceID calledDevice = new DeviceID();
		calledDevice.setValue(callingNumber);
		makeCall.setSubjectOfCall("");
		CorrelatorData correlatorData = new CorrelatorData();
		correlatorData.setString(("Call-"+callingNumber+" "+calledNumber).getBytes());
		makeCall.setCallingDevice(callingDevice);
		makeCall.setCalledDirectoryNumber(calledDevice);
		makeCall.setCorrelatorData(correlatorData);
		MediaCallCharacteristics  mediaCallCharacteristics = new MediaCallCharacteristics();
		MediaClass mediaClass = new MediaClass();
		mediaClass.setVoice(true);
		mediaCallCharacteristics.setMediaClass(mediaClass);
		makeCall.setMediaCallCharacteristics(mediaCallCharacteristics);
		
		
		Entity<MakeCall> entity = Entity.entity(makeCall, MediaType.APPLICATION_XML);

		Response response = invocationBuilder.post(entity);
		//System.out.println( response.readEntity(String.class));
		if (response.getStatus() != 202) {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}
	public static void endCall(String clientSessionId, String callId) throws OpenApiException {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("callcontrol/clearConnection");
		
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);

		ClearConnection clearConnection = new ClearConnection();
		ConnectionID connectionID = new ConnectionID();
		connectionID.setCallID(callId);
		clearConnection.setConnectionToBeCleared(connectionID);
		
		
		Entity<ClearConnection> entity = Entity.entity(clearConnection, MediaType.APPLICATION_XML);

		Response response = invocationBuilder.post(entity);
		//System.out.println( response.readEntity(String.class));
		if (response.getStatus() != 202) {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}
}
