package com.avaya.ipoffice.openapi.samples.adapter.session;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.adapter.OpenApiRestServiceConfig;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Error;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Errors;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.EventType;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.HttpMethod;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.LoginSubscriptionRequest;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginRequest;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;

public class SessionOpenApiRestAdapter {
	
	public static UserLoginResponse login(String username, String password, String appname) throws OpenApiException {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("session");
		
		UserLoginRequest userLoginrequest = new UserLoginRequest();
		userLoginrequest.setUserName(username);
		userLoginrequest.setUserPassword(password);
		userLoginrequest.setApplicationName(appname);
		LoginSubscriptionRequest subscription = new LoginSubscriptionRequest();
		subscription.setHttpMethod(HttpMethod.WEBSOCKET);
		//subscription.getEventTypes().add(EventType.CALL_CONTROL_FEATURES_EVENTS);
		//subscription.getEventTypes().add(EventType.CALL_LOG_EVENTS);
		//subscription.getEventTypes().add(EventType.VOICEMAIL_SERVICES_EVENTS);
		//subscription.getEventTypes().add(EventType.DIRECTORY_EVENTS);
		//subscription.getEventTypes().add(EventType.PRESENCE_EVENTS);
		subscription.getEventTypes().add(EventType.CallControlFeaturesEvents);
		subscription.getEventTypes().add(EventType.CallAssociatedFeaturesEvents);
		subscription.getEventTypes().add(EventType.CallLogEvents);
		subscription.getEventTypes().add(EventType.VoicemailServicesEvents);
		subscription.getEventTypes().add(EventType.DirectoryEvents);
		subscription.getEventTypes().add(EventType.PresenceEvents);
		userLoginrequest.setLoginSubscriptionRequest(subscription);
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML);
		Entity<UserLoginRequest> entity = Entity.entity(userLoginrequest, MediaType.APPLICATION_XML);
		Response response = invocationBuilder.post(entity);
		if (response.getStatus() == 200) {
			UserLoginResponse loginResponse = response.readEntity(UserLoginResponse.class);
			return loginResponse;
		} else {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}
	public static void logout(String clientSessionId) throws OpenApiException {
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("session");
			
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);
		Response response = invocationBuilder.delete();
		if (response.getStatus() != 200) {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}
}
