package com.avaya.ipoffice.openapi.samples.adapter.ui.data;

import java.util.ArrayList;
import java.util.List;

public class DataStore<T> {
	
	protected List<T> dataList = new ArrayList<T>();
	
	public List<T> getDataList() {
		return this.dataList;
	}
	
	public void add(List<T> list) {
		this.dataList.addAll(list);
		notifyDataAddedToListeners(list);
	}
	
	public void add(T obj) {
		this.dataList.add(obj);
		notifyDataAddedToListeners(obj);
	}

	public void update(T obj) {
		notifyDataUpdatedToListeners(obj);
	}
		
	public void remove(T obj) {
		this.dataList.remove(obj);
		notifyDataRemovedToListeners(obj);
	}
	
	public int size() {
		return this.dataList.size();
	}
	
	public int getIndex(T obj) {
		return this.dataList.indexOf(obj);
	}
	
	
	private List<DataChangeListener> listenerList = new ArrayList<DataChangeListener>();
	
	public void addDataChangeListener(DataChangeListener listener) {
		this.listenerList.add(listener);
	}
	
	public void notifyDataAddedToListeners(Object obj) {
		for (DataChangeListener listener : listenerList) {
			listener.notifyDataAdded(obj);
		}
	}

	public void notifyDataUpdatedToListeners(Object obj) {
		for (DataChangeListener listener : listenerList) {
			listener.notifyDataUpdated(obj);
		}
	}

	public void notifyDataRemovedToListeners(Object obj) {
		for (DataChangeListener listener : listenerList) {
			listener.notifyDataRemoved(obj);
		}
	}


}
