package com.avaya.ipoffice.openapi.samples.adapter.ui.data;

import java.util.HashMap;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceState;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresence;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginResponse;

public class SessionDataStore {

	//private UserLoginResponse userSessionInfo;
	private UserDataStore userStore = new UserDataStore();
	private VoicemailDataStore voicemailStore = new VoicemailDataStore();
	private CallLogDataStore callLogStore = new CallLogDataStore();
	private ContactDataStore contactStore = new ContactDataStore();
	private CallDataStore callStore = new CallDataStore();
	private TelephonyPresenceDataStore telephonyPresenceDataStore = new TelephonyPresenceDataStore();
	private XmppPresenceDataStore xmppPresenceDataStore = new XmppPresenceDataStore();

	private static HashMap<String, SessionDataStore> sessionDataStoreMap = new  HashMap<String, SessionDataStore>();
	
	public static SessionDataStore getSessionDataStore(String clientSessionId) {
		if (!sessionDataStoreMap.containsKey(clientSessionId)) {
			sessionDataStoreMap.put(clientSessionId, new SessionDataStore());
		}
		return sessionDataStoreMap.get(clientSessionId);
	}

	
	public UserLoginResponse getUserSessionInfo() {
		return userStore.getDataList().get(0);
	}
	public void setUserSessionInfo(UserLoginResponse userSessionInfo) {
		userStore.getDataList().add(userSessionInfo);
	}
	public UserDataStore getUserDataStore() {
		return userStore;
	}
	public VoicemailDataStore getVoicemailDataStore() {
		return voicemailStore;
	}
	public void setVoicemailDataStore(VoicemailDataStore voicemailStore) {
		this.voicemailStore = voicemailStore;
	}
	public CallLogDataStore getCallLogDataStore() {
		return callLogStore;
	}
	public void setCallLogDataStore(CallLogDataStore callLogStore) {
		this.callLogStore = callLogStore;
	}
	public ContactDataStore getContactDataStore() {
		return contactStore;
	}
	public void setContactDataStore(ContactDataStore contactStore) {
		this.contactStore = contactStore;
	}
	public CallDataStore getCallDataStore() {
		return this.callStore;
	}
	public void setCallDataStore(CallDataStore callStore) {
		this.callStore = callStore;
	}
	public TelephonyPresenceDataStore getTelephonyPresenceDataStore() {
		return telephonyPresenceDataStore;
	}
	public XmppPresenceDataStore getXmppPresenceDataStore() {
		return xmppPresenceDataStore;
	}
}
