package com.avaya.ipoffice.openapi.samples.adapter.voicemail;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMMessageStateChangedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMNewMessageEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotEvent;
import com.avaya.ipoffice.openapi.samples.adapter.ui.data.SessionDataStore;
import com.avaya.ipoffice.openapi.samples.adapter.websocket.OpenApiEventNotifier;

public class VoicemailOpenApiEventAdapter implements OpenApiEventNotifier {
	
	private String clientSessionId;
	
	public VoicemailOpenApiEventAdapter(String clientSessionId) {
		this.clientSessionId = clientSessionId;
	}

	@Override
	public void notifyEvent(Object eventObject) {
		
		if (eventObject instanceof AVMSnapshotEvent) {
			AVMSnapshotEvent avmSnapshotEvent = (AVMSnapshotEvent)eventObject;
			SessionDataStore.getSessionDataStore(clientSessionId).getVoicemailDataStore().add(avmSnapshotEvent.getSnapshotDataList());
		} else if (eventObject instanceof AVMNewMessageEvent) {
			AVMNewMessageEvent avmNewMessageEvent = (AVMNewMessageEvent)eventObject;
		} else if (eventObject instanceof AVMMessageStateChangedEvent) {
			AVMMessageStateChangedEvent avmMessageStateChangedEvent = (AVMMessageStateChangedEvent)eventObject;
		}
	}

}
