package com.avaya.ipoffice.openapi.samples.adapter.voicemail;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.adapter.OpenApiRestServiceConfig;
import com.avaya.ipoffice.openapi.samples.adapter.exception.OpenApiException;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotVoiceMailbox;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DeviceID;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Error;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Errors;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TypeOfNumberEnum;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.UserLoginRequest;

public class VoicemailOpenApiRestAdapter extends OpenApiRestServiceConfig {
	
	public static void getVoicemailSnapshot(String clientSessionId, String extn, String subdomain) throws Exception {
		
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target(OpenApiRestServiceConfig.getOpenApiRestServiceUrl()).path("voicemail/getMessages");
		
		DeviceID device = new DeviceID();
		device.setSwitchingSubDomainInformationElements(subdomain.getBytes());
		device.setValue(extn);
		device.setTypeOfNumber(TypeOfNumberEnum.DEVICE_NUMBER);
		
		AVMSnapshotVoiceMailbox voicemailSnapshotRequest = new AVMSnapshotVoiceMailbox();
		voicemailSnapshotRequest.setDevice(device);
		Entity<AVMSnapshotVoiceMailbox> entity = Entity.entity(voicemailSnapshotRequest, MediaType.APPLICATION_XML);

		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionId);

		Response response = invocationBuilder.post(entity);
		if (response.getStatus() != 202) {
			if (response.getStatus() != 400) {
				Error error = response.readEntity(Error.class);
				throw new OpenApiException(error);
			} else {
				Errors errors = response.readEntity(Errors.class);
				throw new OpenApiException(errors);
			}
		}
	}
}
