package com.avaya.ipoffice.openapi.samples.adapter.websocket;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBContext;

import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMNewMessageEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.AVMSnapshotEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallInformationEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.CallLogEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.ConnectionClearedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.DeliveredEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.EstablishedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.Events;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.HeldEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.PresenceStates;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.RetrievedEvent;
import com.avaya.ipoffice.openapi.samples.adapter.jaxb.TelephonyPresenceEvent;

public class OpenApiWebSocketAdapter {
	
	private String clientSessionId;
	private List<OpenApiEventNotifier> eventNotifiers = new ArrayList<OpenApiEventNotifier>();
	private JAXBContext ctx;
	
	public OpenApiWebSocketAdapter(String clientSessionId) {
		this.clientSessionId = clientSessionId;
		try {
			ctx = JAXBContext.newInstance( 
					PresenceStates.class, 
					TelephonyPresenceEvent.class, 
					AVMSnapshotEvent.class, 
					//AVMNewMessageEvent.class,
					DeliveredEvent.class, EstablishedEvent.class, ConnectionClearedEvent.class,
					CallInformationEvent.class,HeldEvent.class, RetrievedEvent.class,
					CallLogEvent.class,
					Events.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void addOpenApiEventNotifier(OpenApiEventNotifier eventNotifier) {
		this.eventNotifiers.add(eventNotifier);
	}

	public void connect(String webSocketUrl) {
		WebSocketEventMessageListener openApiEventPayloadHandler = new WebSocketEventMessageListener() {

			@Override
			public void notifyEventMessageReceived(String message) {
				System.out.println("Websocket["+clientSessionId+"] received "+ message);
				if (ctx != null) {
					try {
						Events events = (Events)ctx.createUnmarshaller().unmarshal(new StringReader(message));
						Object event = events.getAny().get(0);
						System.out.println(event);
						for (OpenApiEventNotifier eventNotifier : eventNotifiers) {
							eventNotifier.notifyEvent(event);
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				} else {
					System.out.println("Ctx is null. Cannot process message");
				}
			}
			
		};
		
		new OpenApiJettyWebSocketClient(webSocketUrl, openApiEventPayloadHandler);		
		
	}
}
