package com.avaya.ipoffice.openapi.samples;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.ipoffice.openapi.samples.data.*;

//import com.avaya.common.csta.DeviceID;
//import com.avaya.common.csta.TypeOfNumberEnum;
//import com.avaya.common.csta.MediaCallCharacteristics;
//import com.avaya.common.csta.MediaClass;

public class CallControlSample {

	public static void main(String arg[]) {
		LoginSample user1 = new LoginSample();
		user1.login("Extn111", "1234", "148.147.216.234", "8080");
		LoginSample user2 = new LoginSample();
		user2.login("Extn222", "1234", "148.147.216.234", "8080");
		
		callcontrol(user1.clientSessionID, user2.clientSessionID);
	}
	
	public static void callcontrol(String clientSessionID1, String clientSessionID2)
	{
		oneCallCycle(clientSessionID1, clientSessionID2);
		clearConnection(clientSessionID1);
		
	}
	public static void oneCallCycle(String clientSessionID1, String clientSessionID2)
	{
		//Makecall-111-222-----------------------------------------------
		MakeCall makeCall = new MakeCall();
		DeviceID callingDevice = new DeviceID();
		//callingDevice.setSwitchingSubDomainInformationElements("148.147.216.234".getBytes());
		callingDevice.setSwitchingSubDomainInformationElements("127.0.0.1".getBytes());
		callingDevice.setValue("111");
		callingDevice.setTypeOfNumber(TypeOfNumberEnum.DIALING_NUMBER);
		
		DeviceID calledDirectoryNumber = new DeviceID();
		//calledDirectoryNumber.setSwitchingSubDomainInformationElements("127.0.0.1".getBytes());
		calledDirectoryNumber.setValue("222");
		//calledDirectoryNumber.setTypeOfNumber(TypeOfNumberEnum.DEVICE_NUMBER);
		calledDirectoryNumber.setTypeOfNumber(TypeOfNumberEnum.DIALING_NUMBER);
	
	
		makeCall.setCallingDevice(callingDevice);
		makeCall.setCalledDirectoryNumber(calledDirectoryNumber);
		makeCall.setAutoOriginate(AutoOriginate.DO_NOT_PROMPT);
		
		String callId = "makecall-111-222";
		CorrelatorData correlatorData = new CorrelatorData();
		correlatorData.setString(callId.getBytes());
		
		makeCall.setCorrelatorData(correlatorData);
		
		MediaCallCharacteristics mediaCallCharacteristics = new MediaCallCharacteristics();
		MediaClass mediaClass = new MediaClass();
		mediaClass.setVoice(true);
		mediaCallCharacteristics.setMediaClass(mediaClass);
		
		makeCall.setMediaCallCharacteristics(mediaCallCharacteristics);
		makeCall.setSubjectOfCall("");
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target("http://148.147.216.234:8080/inyama/service").path("callcontrol/makeCall");
		System.out.println(webTarget.getUri());
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionID1);
		Entity<MakeCall> entity = Entity.entity(makeCall, MediaType.APPLICATION_XML);
		Response response = invocationBuilder.post(entity);
		
		System.out.println(response.readEntity(String.class));
		
		/*try {
			Thread.sleep(5000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}*/
		
		//Answercall-by-222-----------------------------------------------
		
		/*client = ClientBuilder.newClient();
		webTarget = client.target("http://148.147.216.234:8080/inyama/service").path("websocketevents");
		System.out.println(webTarget.getUri());
	
		invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionID2);
		response = invocationBuilder.get();
		
		System.out.println(response.readEntity(String.class));*/
	}
	public static void clearConnection(String clientSessionID)
	{
		/*ConnectionID conn = new ConnectionID();
		conn.setCallID("makecall-111-222");
		ClearConnection clearConnection = new ClearConnection();
		clearConnection.setConnectionToBeCleared(conn);
		
		Client client = ClientBuilder.newClient();
		WebTarget webTarget = client.target("http://148.147.216.234:8080/inyama/service").path("callcontrol/clearConnection");
		System.out.println(webTarget.getUri());
	
		Invocation.Builder invocationBuilder =	webTarget.request(MediaType.APPLICATION_XML).header("ClientSessionId", clientSessionID);
		Entity<ClearConnection> entity = Entity.entity(clearConnection, MediaType.APPLICATION_XML);
		Response response = invocationBuilder.post(entity);
		System.out.println(response.getStatus());*/
	}
}
